% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{aple}
\alias{aple}
\title{Spatial autocorrelation estimator}
\source{
Li, Honfei and Calder, Catherine A. and Cressie, Noel (2007). Beyond Moran's I: testing for spatial dependence based on the spatial autoregressive model. Geographical Analysis: 39(4): 357-375.
}
\usage{
aple(x, w, digits = 3)
}
\arguments{
\item{x}{Numeric vector of values, length \code{n}. This will be standardized internally with \code{scale(x)}.}

\item{w}{An \verb{n x n} row-standardized spatial connectivity matrix. See \link[geostan]{shape2mat}.}

\item{digits}{Number of digits to round results to.}
}
\value{
the APLE estimate, a numeric value.
}
\description{
The approximate-profile likelihood estimator for the spatial autocorrelation parameter from a simultaneous autoregressive (SAR) model (Li et al. 2007). Note, the \code{APLE} approximation is not reliable when the number of observations is large.
}
\details{
The \code{APLE} is an estimate of the spatial autocorrelation parameter one would obtain from fitting an intercept-only SAR model.
}
\examples{
library(sf)
data(georgia)
w <- shape2mat(georgia, "W")
x <- georgia$ICE
aple(x, w)
}
\seealso{
\link[geostan]{mc}, \link[geostan]{moran_plot}, \link[geostan]{lisa}, \link[geostan]{sim_sar}
}
