% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{delta_h_global}
\alias{delta_h_global}
\title{Computes a Global Knot Distance from the Input}
\usage{
delta_h_global(G, delta = NULL, h = NULL)
}
\arguments{
\item{G}{An object of class \code{gn}) or a point pattern on a geometric
network (object of class \code{gnpp}).}

\item{delta}{A numeric vector of length one which already defines
the global knot distance. Alternatively, delta can be supplied in terms of a
quantile of the curve lengths of the network, i.e. a number in the unit
interval. In the latter case, delta must be supplied as a character vector of
length one, see the examples. By default, delta is chosen to be half of the
minimal curve length.}

\item{h}{A numeric vector of length one which already defines the
global knot distance h. Alternatively, h can be supplied in terms of a
fraction of delta, i.e. a number in the interval (0,1]. In the latter case,
h must be supplied as character vector of length one, see the examples.
By default, h is chosen to be half of the global knot distance.}
}
\value{
The global knot distance delta.
}
\description{
Computes a Global Knot Distance from the Input
}
\examples{
G <- as_gn(montgomery)
# use default arguments
setup <- delta_h_global(G)
setup
# set numeric value for delta and fraction for h
setup <- delta_h_global(G, delta = 0.1, h = "0.25")
setup
# set quantile for delta
setup <- delta_h_global(G, delta = "0.05")
setup
}
\author{
Marc Schneble \email{marc.schneble@stat.uni-muenchen.de}
}
