% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNUtils.R
\docType{class}
\name{GNUtils}
\alias{GNUtils}
\title{GeoNetwork REST API Manager Utils}
\format{\code{\link{R6Class}} object.}
\usage{
GNUtils
}
\value{
Object of \code{\link{R6Class}} with static util methods for communication
with the REST API of a GeoNetwork instance.
}
\description{
GeoNetwork REST API Manager Utils
}
\section{Static methods}{

\describe{
 \item{\code{getUserAgent()}}{
   This method is used to get the user agent for performing GeoNetwork API requests.
   Here the user agent will be compound by geonapi package name and version.
 }
 \item{\code{getUserToken(user, pwd)}}{
   This method is used to get the user authentication token for performing GeoNetwork
   API requests. Token is given a Base64 encoded string.
 }
 \item{\code{GET(url, path, token, verbose)}}{
   This method performs a GET request for a given \code{path} to GeoNetwork REST API
 }
 \item{\code{PUT(url, path, token, filename, contentType, verbose)}}{
   This method performs a PUT request for a given \code{path} to GeoNetwork REST API,
   to upload a file of name \code{filename} with given \code{contentType}
 }
 \item{\code{POST(url, path, token, content, contentType, verbose)}}{
   This method performs a POST request for a given \code{path} to GeoNetwork REST API,
   to post content of given \code{contentType}
 }
 \item{\code{DELETE(url, path, token, verbose)}}{
   This method performs a DELETE request for a given GeoNetwork resource identified
   by a \code{path} in GeoNetwork REST API
 }
 \item{\code{parseResponseXML(req)}}{
   Convenience method to parse XML response from GeoNetwork REST API. Although package \pkg{httr}
   suggests the use of \pkg{xml2} package for handling XML, \pkg{geonapi} still relies
   on the package \pkg{XML}. Response from \pkg{httr} is retrieved as text, and then parsed as
   XML 'xmlParse' function.
 }
 \item{\code{getPayloadXML(obj)}}{
   Convenience method to create payload XML to send to GeoNetwork.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonetwork}
\keyword{rest}
