% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob_textpath.R
\name{textpathGrob}
\alias{textpathGrob}
\title{Draw text on a path.}
\usage{
textpathGrob(
  label,
  x = 0.5,
  y = 0.5,
  id = 1L,
  just = "centre",
  hjust = NULL,
  vjust = NULL,
  halign = "left",
  angle = 0,
  straight = FALSE,
  rich = FALSE,
  gp_text = gpar(),
  gp_path = gpar(),
  gp_box = gpar(),
  gap = NA,
  upright = TRUE,
  text_smoothing = 0,
  polar_params = NULL,
  padding = unit(0.05, "inch"),
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  remove_long = FALSE,
  arrow = NULL,
  default.units = "npc",
  name = NULL,
  vp = NULL,
  as_label = FALSE
)
}
\arguments{
\item{label}{A \code{character} vector.}

\item{x}{A \code{numeric} vector.}

\item{y}{A \code{numeric} vector.}

\item{id}{A \code{numeric} vector used to separate locations in \code{x} and \code{y} into
multiple lines. All locations with the same \code{id} belong to the same line.}

\item{just}{The justification of the text
    relative to its (x, y) location.  If there are two values, the first
    value specifies horizontal justification and the second value specifies
    vertical justification.  Possible string values are: \code{"left"},
    \code{"right"}, \code{"centre"}, \code{"center"}, \code{"bottom"},
    and \code{"top"}.  For numeric values, 0 means left (bottom) alignment
    and 1 means right (top) alignment.
  }

\item{hjust}{A numeric vector specifying horizontal justification.
    If specified, overrides the \code{just} setting.}

\item{vjust}{A \code{numeric} vector specifying justification orthogonal to the
direction of the text. Alternatively a \code{\link[grid:unit]{unit()}} object to
directly set the offset from the path.}

\item{halign}{A \code{character(1)} describing how multi-line text should be
justified. Can either be \code{"center"} (default), \code{"left"} or \code{"right"}.}

\item{angle}{a \code{numeric} vector either length 1 or the same length as \code{id}
describing the angle in degrees at which text should be rotated.}

\item{straight}{A \code{logical(1)} which if \code{TRUE}, keeps the letters of a label
on a straight baseline and if \code{FALSE} (default), lets individual letters
follow the curve. This might be helpful for noisy paths.}

\item{rich}{A \code{logical(1)} whether to interpret the text as html/markdown
formatted rich text. Default: \code{FALSE}. See also the rich text section of
the details in \code{\link[=geom_textpath]{geom_textpath()}}.}

\item{gp_text, gp_path}{An object of class \code{"gpar"}, typically the output from
a call from the \code{\link[grid:gpar]{gpar()}} function. These are basically lists
of graphical parameters for the text and path respectively.}

\item{gp_box}{(Optional) an object of class \code{"gpar"}, typically the output
from a call to the \code{\link[grid:gpar]{gpar()}} function. If this is an empty
list, no text box will be drawn.}

\item{gap}{A \code{logical(1)} which if \code{TRUE}, breaks the path into two sections
with a gap on either side of the label. If \code{FALSE}, the path is plotted
as a whole. Alternatively, if \code{NA}, the path will be broken if the string
has a \code{vjust} between 0 and 1, and not otherwise. The default for the label
variant is \code{FALSE} and for the text variant is \code{NA}.}

\item{upright}{A \code{logical(1)} which if \code{TRUE} (default), inverts any text
where the majority of letters would upside down along the path, to improve
legibility. If \code{FALSE}, the path decides the orientation of text.}

\item{text_smoothing}{a \code{numeric(1)} value between 0 and 100 that smooths
the text without affecting the line portion of the geom. The default value
of \code{0} means no smoothing is applied.}

\item{polar_params}{a list consisting of an x, y, and r component that
specifies the central point and radius of a circle around which
single-point labels will be wrapped.}

\item{padding}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the
padding between the text and the path when the \code{gap} parameter trims the
path.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{remove_long}{if TRUE, labels that are longer than their associated
path will be removed.}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{arrow()}}.}

\item{default.units}{A string indicating the default units to use
    if \code{x} or \code{y}
    are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{vp}{A Grid viewport object (or NULL).}

\item{as_label}{a \code{logical} TRUE or FALSE indicating whether the text should
be drawn inside a text box. If FALSE, the parameters \code{label.padding},
\code{label.r} and \code{gp_box} will be ignored.}
}
\value{
An object of class \code{gTree}, containing grobs.
}
\description{
This function creates (curved) text on a path.
}
\examples{
require(grid)

t <- seq(0, 2 * pi, length.out = 100)
grob <- textpathGrob(
  label = c(
    "Why I am making trigonometry jokes? Cos I can!",
    "I was never any good at sine language."
  ),
  x = c(t, t) / (2 * pi),
  y = c(cos(t), sin(t)) * 0.25 + 0.5,
  id = rep(1:2, each = length(t)),
  vjust = rep(0.5, 2 * length(t)),
  gp_text = gpar(lineheight = c(1.2, 1.2), fontsize = c(10, 10)),
  gp_path = gpar(lty = c(1, 2))
)

grid.newpage(); grid.draw(grob)
}
