% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{gm_coordinates}
\alias{gm_coordinates}
\title{gm_coordinates}
\usage{
gm_coordinates(x)
}
\arguments{
\item{x}{object representing geometry shapes (e.g., list of matrices)}
}
\value{
a single data.frame representing all the values in the input lists and matrices.
}
\description{
Converts all coordinates from various geometric shapes into a single data.frame.
}
\details{
The data.frame returned will always have an 'id' column. Then will follow an
'id+counter' column for every level of nesting the geometry is within.

The coordinates always start in column 'c1', the first column after all the id columns.
Then there is a column 'c+counter' for every coordinate in the geometry.

This function is designed to handle multiple and different nested of geometry structures.
}
\examples{

x <- 1:3
gm_coordinates( x )

m <- matrix(1:12, ncol = 3)
gm_coordinates( m )

l <- list(
  matrix(1:12, ncol = 2 )
)
gm_coordinates( l )

l <- list(
  matrix(1:12, ncol = 4 )
)
gm_coordinates( l )

l <- list(
  list(
    matrix(1:12, ncol = 2)
  )
)
gm_coordinates( l )

l <- list(
  list(
    matrix(1:12, ncol = 2)
    , matrix(1:4, ncol = 2)
  )
)
gm_coordinates( l )

l <- list(
  list(
    matrix(1:12, ncol = 2)
    , matrix(1:4, ncol = 2)
  )
  , 1:5
  , 1:2
  , matrix(1:9, ncol = 3)
)
gm_coordinates( l )

l <- list(
  matrix(1:4, ncol = 2)
  , list(
    matrix(1:9, ncol = 3)
  )
)
gm_coordinates( l )

l <- list(
  list(
    list(
      matrix(1:12, ncol = 2)
    )
  )
  , list(
    list(
     matrix(1:24, ncol = 2)
   )
  )
)
gm_coordinates( l )

l <- list(
  list(
    list(
      matrix(1:12, ncol = 2)
    )
  )
  , list(
    list(
      matrix(1:3, ncol = 3)
     , matrix(1:24, ncol = 2)
   )
  )
)
gm_coordinates( l )


}
