% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOAddress.R
\docType{class}
\name{ISOAddress}
\alias{ISOAddress}
\title{ISOAddress}
\format{\code{\link{R6Class}} object.}
\usage{
ISOAddress
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Address
}
\description{
ISOAddress
}
\section{Fields}{

\describe{
\item{\code{deliveryPoint}}{[\code{\link{character}}]}

\item{\code{city}}{[\code{\link{character}}]}

\item{\code{postalCode}}{[\code{\link{character}}]}

\item{\code{country}}{[\code{\link{ISOCountry}}]}

\item{\code{electronicMailAddress}}{[\code{\link{character}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOAddress}}
 }
 \item{\code{setDeliveryPoint(deliveryPoint, locales)}}{
   Sets the delivery point. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setCity(city, locales)}}{
   Sets the city. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setPostalCode(postalCode, locales)}}{
   Sets the postal code. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setCountry(country, locales)}}{
   Sets the country. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setEmail(email, locales)}}{
   Sets the electronic Mail address. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
}
}

\examples{
 md <- ISOAddress$new()
 md$setDeliveryPoint("theaddress")
 md$setCity("thecity")
 md$setPostalCode("111")
 md$setCountry("France")
 md$setEmail("someone@theorg.org")
 xml <- md$encode()
 
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{address}
