% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISORelativeInternalPositionalAccuracy.R
\docType{class}
\name{ISORelativeInternalPositionalAccuracy}
\alias{ISORelativeInternalPositionalAccuracy}
\title{ISORelativeInternalPositionalAccuracy}
\format{\code{\link{R6Class}} object.}
\usage{
ISORelativeInternalPositionalAccuracy
}
\value{
Object of \code{\link{R6Class}} for modelling an ISORelativeInternalPositionalAccuracy
}
\description{
ISORelativeInternalPositionalAccuracy
}
\section{Inherited methods}{

\describe{
  from \code{ISODataQualityAbstractElement}
}
}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISORelativeInternalPositionalAccuracy
 }
}
}
\examples{
#encoding
  dq <- ISORelativeInternalPositionalAccuracy$new()
  dq$addNameOfMeasure("measure")
  metaId <- ISOMetaIdentifier$new(code = "measure-id")
  dq$setMeasureIdentification(metaId)
  dq$setMeasureDescription("description")
  dq$setEvaluationMethodDescription("method description")
  dq$setEvaluationMethodType("indirect")
  dq$setDateTime(ISOdate(2015,1,1,12,10,49))
  spec <- ISOCitation$new()
  spec$setTitle("specification title")
  spec$setAlternateTitle("specification alternate title")
  d <- ISODate$new()
  d$setDate(ISOdate(2015, 1, 1, 1))
  d$setDateType("publication")
  spec$addDate(d)
  dq$setEvaluationProcedure(spec)
  result <- ISOConformanceResult$new()
  result$setSpecification(spec)
  result$setExplanation("some explanation about the conformance")
  result$setPass(TRUE)
  dq$addResult(result)
  xml <- dq$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{accuracy}
\keyword{data}
\keyword{internal}
\keyword{positional}
\keyword{quality}
\keyword{relative}

