% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GMLTimePeriod.R
\docType{class}
\name{GMLTimePeriod}
\alias{GMLTimePeriod}
\title{GMLTimePeriod}
\format{\code{\link{R6Class}} object.}
\usage{
GMLTimePeriod
}
\value{
Object of \code{\link{R6Class}} for modelling an GMLTimePeriod
}
\description{
GMLTimePeriod
}
\section{Fields}{

\describe{
\item{\code{beginPosition}}{}

\item{\code{endPosition}}{}

\item{\code{duration}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml, beginPosition, endPosition)}}{
   This method is used to instantiate an GMLTimePeriod
 }
 \item{\code{setBeginPosition(beginPosition)}}{
   Sets the begin position (beginning date or date and time of the resource
   contents), as object of class "POSIXct"/"POSIXt" or "Date"
 }
 \item{\code{setEndPosition(endPosition)}}{
   Sets the end position (ending date or date and time of the resource
   contents), as object of class "POSIXct"/"POSIXt" or "Date"
 }
 \item{\code{computeInterval()}}{
  Computes the ISO interval string and set as GML id
 }
 \item{\code{setId(id)}}{
 Sets the GML id string.
 }
 \item{\code{setDuration(years, months, days, hours, mins, secs)}}{
   Set duration (Length of time between measurements)
 }
}
}
\examples{
start <- ISOdate(2000, 1, 12, 12, 59, 45)
  end <- ISOdate(2010, 8, 22, 13, 12, 43)
  md <- GMLTimePeriod$new(beginPosition = start, endPosition = end)
  xml <- md$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{period}
\keyword{time}

