% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geogrid-package.R
\docType{package}
\name{geogrid}
\alias{geogrid}
\alias{geogrid-package}
\title{geogrid}
\description{
Turn irregular polygons (such as geographical regions) into regular grids.
}
\examples{
\dontrun{
input_file <- system.file("extdata", "london_LA.json", package = "geogrid")
original_shapes <- read_polygons(input_file)

# calculate grid
new_cells <- calculate_grid(shape = original_shapes,
  grid_type = "hexagonal", seed = 1)
plot(new_cells)

#
grid_shapes <- assign_polygons(original_shapes, new_cells)
par(mfrow=c(1, 2))
sp::plot(original_shapes)
sp::plot(grid_shapes)

# look at different grids using different seeds
par(mfrow=c(2, 3), mar = c(0, 0, 2, 0))
for (i in 1:6) {
  new_cells <- calculate_grid(shape = original_shapes, grid_type = "hexagonal", seed = i)
  plot(new_cells, main = paste("Seed", i, sep=" "))
}
}
}
\author{
Joseph Bailey <jbailey@futurecities.catapult.org.uk>
}
