.create.fd.object <-
function(data, smooth.type, argvals, nbasis, lambda){

  if(smooth.type == "fourier"){
    n <- dim(data)[1]
  }

  s <- dim(data)[2] # number of sites

##################################################################
#  Creating a fd object
##################################################################

  rangeval <- range(argvals)

  if(smooth.type == "fourier"){

    period <- n
    basis <- create.fourier.basis(rangeval, nbasis, period)
    datafd <- Data2fd(argvals=argvals, y=data, basisobj=basis, lambda=lambda)

  }else{
    # 4 define un spline cubico
    norder <- 4
    basis <- create.bspline.basis(rangeval, nbasis, norder)

    datafdPar <- fdPar(basis, Lfdobj=2, lambda)
    smooth.datafd <- smooth.basis(argvals, data, datafdPar)
    datafd <- smooth.datafd$fd   
  }

##################################################################
# Calculating L2 norm among functions
# Integral del cuadrado de las diferencias entre las funciones
##################################################################

  if(smooth.type == "fourier"){
    M <- fourierpen(basis,Lfdobj=0)
  }else{
    M <- bsplinepen(basis,Lfdobj=0)
  }

  return( list(M=M, datafd=datafd) )

}

.okfd.predict <-
function(argvals, datafd, coords, new.coords, trace.vari, Eu.d){

  s <- dim(coords)[1]

  # Distances among sites and distances to the prediction site
  # Distance matrix among sampling sites and distance to NEW SITES
  new.s <- dim(new.coords)[1]
  new.Eu.d <- as.matrix(dist(rbind(coords,new.coords), method="euclidean"))
  new.Eu.d <- matrix(new.Eu.d[1:s,(s+1):(s+new.s)], nrow=s, ncol=new.s)

  # Solving the system
  sigma2 <- trace.vari$cov.pars[1]
  leftmatrix <- sigma2 - cov.spatial(Eu.d, cov.model=trace.vari$cov.model, cov.pars=trace.vari$cov.pars, kappa=trace.vari$kappa)
  unosfila <- rep(1,s)
  leftmatrix <- rbind(leftmatrix, unosfila)
  unosycerocolumna <- c(rep(1,s),0)
  leftmatrix <- cbind(leftmatrix, unosycerocolumna)

  rightmatrix <- sigma2 - cov.spatial(new.Eu.d, cov.model=trace.vari$cov.model, cov.pars=trace.vari$cov.pars, kappa=trace.vari$kappa)
  unosfila <- rep(1, new.s)
  rightmatrix <- rbind(rightmatrix, unosfila)

  functional.kriging.weights <- solve(leftmatrix, rightmatrix)
  functional.kriging.weights.sinlagrange <- matrix(functional.kriging.weights[-(s+1),], nrow=s, ncol=new.s)
  sum(functional.kriging.weights.sinlagrange)

  # Solution
  eval.data <- eval.fd(argvals, datafd)
  krig.new.data <- eval.data%*%functional.kriging.weights.sinlagrange

  # Prediction variance
  vect.semiv <-rightmatrix[-(s+1),]
  varianza <-functional.kriging.weights.sinlagrange*vect.semiv 
  suma.varianza<-sum(varianza)
  pred.var <- suma.varianza + functional.kriging.weights[s+1,]

  return( list(pred=krig.new.data, var=pred.var, new.Eu.d=new.Eu.d, functional.kriging.weights=functional.kriging.weights) )

}
.Random.seed <-
c(403L, 10L, 8403068L, -1197935406L, 2004077645L, -42894073L, 
-632561426L, 1750135240L, -299149621L, -2056362199L, 532524920L, 
1291080870L, 72775361L, 404721491L, -375100414L, 1351719220L, 
-546573641L, -206598483L, 589275076L, -212490262L, 260532309L, 
1293415919L, -27771402L, -1319687392L, 1025369315L, -14065279L, 
-1469237264L, 583538318L, 2043394553L, 242037643L, 1800249274L, 
544050876L, 1554155007L, -1210424491L, -1874848660L, -249704254L, 
825725725L, -1416599145L, -1446358786L, 1038541496L, 1590574235L, 
280349433L, 1533115464L, 295788406L, 1024633521L, -2025911581L, 
-904320590L, 1632688644L, -1062809273L, 1014676509L, 693621396L, 
-745055686L, -1891543931L, -1571608225L, -211908122L, -1991813008L, 
-23155821L, -1592280015L, -151465248L, 1716495230L, 1389943305L, 
305312315L, 1780845578L, -165276692L, -803473297L, -1297131611L, 
-1718263972L, -1461976270L, -1142912467L, 82995431L, -2144851442L, 
979556328L, 77703659L, -307185015L, 212972056L, -151013050L, 
-1037781087L, 804633139L, -183814238L, -1479855468L, -1514084073L, 
-713189619L, -730395100L, 2096526858L, 915959669L, 420354767L, 
1335057878L, 388428160L, -1316910653L, 43941729L, -786324016L, 
1205810478L, 467051737L, -2093809941L, 2052750170L, -1496384228L, 
1916484639L, 910811253L, 755260684L, 1766944994L, 1201027517L, 
-285688265L, -816663330L, -1699696616L, -1128149125L, 1444155161L, 
848917416L, 376390486L, 710769617L, 907644803L, 1369225746L, 
-801788508L, 999184743L, 881870525L, -1368216012L, -1129957990L, 
-1217859099L, 1087552895L, -1789987578L, -1438314864L, 877168435L, 
799560913L, -1717039488L, 1594398558L, 1946776745L, -663255205L, 
350813546L, -667480052L, 1207945295L, -1648615163L, -2011113028L, 
-30569326L, 670119821L, -1226985529L, -1200663378L, 408786184L, 
-1640905973L, 1076030953L, 1356577464L, -2108187290L, 310449665L, 
2143977619L, -1764902078L, -879954700L, 1356259575L, 46160109L, 
1551489924L, 1327199658L, 1488939797L, 1286478255L, -1125115466L, 
845397984L, -816279773L, -74391487L, -1453016272L, -1857097394L, 
204399545L, -251816501L, -282958214L, -1858417796L, -1556855873L, 
-1687343979L, -1712049492L, 1712124034L, -2140422051L, -943163561L, 
1458367038L, 1618534008L, 1560296795L, -1252807495L, 1335182600L, 
699582390L, -564302607L, -1966331101L, 474393970L, 1009829828L, 
762110855L, -595611299L, 1479798612L, 2112206202L, 1987809477L, 
783757855L, 275878L, -262621392L, 1330036179L, 1533496305L, -115757792L, 
-1536939074L, -1225350199L, 231469947L, 666882378L, 1674100140L, 
1947650223L, -1310338459L, -562689508L, 17376370L, -526050579L, 
1524270887L, -1759239346L, 1031449512L, 243175339L, 1027710153L, 
-1532007208L, -1239862906L, 1367083105L, 811493875L, 701962338L, 
-496595244L, -1158981673L, 1220904397L, -40885916L, -517741238L, 
892691637L, -244751345L, -1011352298L, -811710528L, -1264389245L, 
63586721L, 251293072L, -501506450L, -209991655L, 1187058859L, 
852273306L, -1971210148L, 2042443103L, 418234165L, -592375092L, 
1026707490L, -382797187L, -1792328496L, -617862868L, -1956456716L, 
-1863690862L, 229064800L, 966149388L, 1060328160L, -957631134L, 
-157865304L, 1909559884L, -199561860L, 1966256434L, 124402800L, 
885629764L, 376256984L, -532804486L, -1474912720L, -1043320132L, 
-2073285804L, 719118402L, 607627680L, -1414818116L, -1951033904L, 
-257315486L, 806035432L, 2127687628L, -344589572L, 1372646898L, 
-1617599360L, 803299572L, -812236152L, -1946320070L, 462159696L, 
-52202900L, -303679340L, -1157324462L, 1859725024L, 1911660236L, 
-615382880L, 1807034242L, -81680664L, 658775788L, -6406084L, 
-1663431054L, 1864408176L, 351388196L, 569872440L, 1586927642L, 
-391424304L, -2059215812L, 1889092756L, -329586558L, 1423134656L, 
-945608388L, 1349357200L, -772274142L, 1071335432L, 732085388L, 
-626805732L, 1758888594L, -1661882240L, -449567724L, 1668620584L, 
-497509830L, 2044875984L, -1413235604L, 2120892084L, 912910354L, 
1948725216L, 317967308L, -1418967584L, -1826219486L, -255109848L, 
-737628916L, 2063664700L, 564746482L, 1990584048L, -1938358460L, 
76088920L, -1464219078L, 21942000L, 1252309180L, -1407968748L, 
202742978L, -2072122272L, 109841788L, 2034784464L, 687950882L, 
1064330920L, 385330060L, -1360439876L, -77437902L, -401551552L, 
-1003510604L, -761667768L, 291680954L, -1749532912L, 806700268L, 
-1194398636L, -968626414L, 1679417248L, -726719540L, 1482054496L, 
1141302466L, -1318437336L, 1936227756L, -1330648260L, 1966692210L, 
-1915289808L, -2094008796L, -590992328L, 502687962L, 1928297872L, 
-829465860L, 459023252L, 1440669506L, 308446720L, -277254596L, 
-1884417456L, 435363490L, 888523592L, 728818188L, -1162028836L, 
-1577543086L, -184747904L, -28228780L, -1686942232L, -1968025862L, 
1930873680L, -2102031316L, -1065764492L, -119695726L, 319544928L, 
1106474636L, 1361352544L, 1600332514L, -409841496L, -1265214260L, 
-1171385860L, 24537010L, 870828528L, -441567804L, -16092328L, 
1407045498L, -913480272L, 245243324L, -410735532L, 658919362L, 
1847924512L, 870785980L, 1496178256L, -696313374L, 35071336L, 
-842640052L, -1192805124L, -1764351246L, 1990347520L, -1439175052L, 
1665989640L, -981464646L, 1929751504L, 1229706732L, 1194262420L, 
-2067902766L, -805795232L, 2119423308L, -1489694432L, -2135103870L, 
-1224505880L, 1314937836L, 1990466108L, -2123291022L, -2010129552L, 
158480676L, -132961736L, -1706481254L, -1720046128L, 1282870716L, 
-237689708L, 1393315970L, -1935641152L, -1539897540L, -1356687216L, 
239995682L, 725058056L, -1604255476L, 167651740L, 645503506L, 
-2011766912L, 394883860L, -1812489944L, -1829330886L, 1119802320L, 
141854316L, 626651700L, 720623250L, 903679328L, 1509597516L, 
-1836289056L, 1990640034L, 415818152L, -1409483124L, -1545538116L, 
183706226L, -1513903120L, -192832956L, 1145380952L, 926463034L, 
1876499568L, -2074180548L, -1460806380L, -2047286590L, 1502680800L, 
-831005572L, 1830552272L, 1461281186L, -767486936L, -1719560436L, 
2084963772L, 2070816562L, -717222208L, -1846417356L, -1646776632L, 
891349178L, 935969424L, 72689388L, 529977940L, -737231563L, 1453472914L, 
-520407968L, 346886601L, 827410683L, -124700980L, 731122522L, 
1017663055L, -728855783L, -1783343826L, -2090733764L, -2098983763L, 
1557618519L, -1709608288L, 1858558L, 1708866251L, -1470079795L, 
824541178L, -944606152L, -259869215L, 529415827L, 1709018292L, 
-1572416062L, 465315287L, 1705314849L, -292357658L, -1687072540L, 
-760270827L, -252465089L, -200482856L, -1935220234L, 2068537859L, 
1929196869L, 1671176546L, -981292336L, 607553017L, 1681812779L, 
-316330340L, -2037302070L, -915450433L, -1515214583L, -2143385058L, 
-822835252L, 1129051549L, 1944301607L, -803692976L, 1919757038L, 
-828091493L, -1076084227L, 838710506L, 983613320L, 1746458929L, 
1786505635L, 2101927332L, 466698322L, 58971047L, 216025073L, 
-457284810L, -1110872108L, -1470294683L, -1562748561L, 1371988904L, 
577767686L, 118073395L, 466321045L, 782915314L, 2074486592L, 
-1260948311L, 1772095771L, -1563128084L, -1953942790L, 2143820591L, 
-497171655L, 1397101902L, 1847813020L, -369792755L, 452946807L, 
2118418304L, 1185705438L, 943952555L, 886066605L, -329522662L, 
-688098088L, -40879807L, -1139695117L, -1548146668L, 183168418L, 
-1577194825L, 1687307393L, -1106938746L, -1008226108L, 510004725L, 
-1099409313L, 95126200L, -242689130L, -19650141L, -1108304539L, 
-2017264510L, -1670212112L, 703980441L, 1723352459L, 666906748L, 
1139561130L, -1387442977L, -673904023L, -1687820162L, -1717424020L, 
-1011201859L, -736527993L, 563768688L, -1040492530L, -1179904709L, 
773224989L, 937287370L, 713660904L, -238235951L, 2075265731L, 
1771585988L, -2046892430L, -1818192057L, 1876592401L, -1973290346L, 
-656400396L, 962636165L, -292281137L, 1915657672L, -185371546L, 
1435677331L, 1979185653L, 2133971922L, -1671952352L, 1334141449L, 
2097773371L, -953889140L, 1892180762L, -1580702321L, -1375618343L, 
1968543086L, -742967044L, -406584723L, 1770642967L, 1709202400L, 
-1996183618L, -1790749301L, -601897459L, -1947461062L, -1486261640L, 
-1901995487L, 1468298451L, -693308428L, 392057986L, 873692439L, 
12168161L, 1161887014L, -1507345372L, 1750382293L, 1692070527L, 
1453957912L, 556939830L, 1767595203L, 1912303877L, -1572575070L, 
1070153360L, 181418553L, -158416149L, -358005796L, -98621942L, 
1869682943L, -660390583L, 236996562L)
.simple.fdmodel <-
function(new.coords, coords, data,
    smooth.type=NULL, nbasis=max(50,dim(data)[1]), argvals=seq(0, 1, len = dim(data)[1]), lambda=0,
    cov.model=NULL, fix.nugget=FALSE, nugget=0, fix.kappa=TRUE, kappa=0.5, max.dist.variogram=NULL){

  # Number of sites
  s <- dim(data)[2]

  # Smoothing original data
  fdobjects <- .create.fd.object(data, smooth.type, argvals, nbasis, lambda)

  # Calculating L2 norm among functions
  L2norm <- l2.norm(s, fdobjects$datafd, fdobjects$M)

  # Empirical trace-variogram
  emp.trace.vari <- trace.variog(coords, L2norm)

  # Fitting a theoretical variogram model to empirical trace-variogram
  if(smooth.type == "fourier"){
    # partial sill is set to the quantile 0.75
    sigma2.0 <- quantile(emp.trace.vari$v, 0.75)
  }else{
    # partial sill is set to the variance of the data
    sigma2.0 <- var(as.vector(data))
  }
  trace.vari.objects <- fit.tracevariog(emp.trace.vari=emp.trace.vari, models=cov.model, sigma2.0=sigma2.0, phi.0=quantile(emp.trace.vari$Eu.d, 0.75), fix.nugget, nugget, fix.kappa, kappa, max.dist.variogram)

  return( list(fdobjects=fdobjects, emp.trace.vari=emp.trace.vari, trace.vari.objects=trace.vari.objects) )

}
