% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_indices.R
\name{spConsistency}
\alias{spConsistency}
\title{Spatial consistency index}
\usage{
spConsistency(object, nblistw = NULL, window = NULL, nrep = 999, adj = FALSE)
}
\arguments{
\item{object}{A FCMres object, typically obtained from functions CMeans,
GCMeans, SFCMeans, SGFCMeans. Can also be a simple membership matrix.}

\item{nblistw}{A list.w object describing the neighbours typically produced
by the spdep package. Required if data is a dataframe, see the parameter window
if you use a list of rasters as input. Can also be NULL if object is a FCMres object.}

\item{window}{if rasters were used for the classification, the window must be
specified instead of a list.w object. Can also be NULL if object is a FCMres object.}

\item{nrep}{An integer indicating the number of permutation to do to simulate
spatial randomness. Note that if rasters are used, each permutation can be very long.}

\item{adj}{A boolean indicating if the adjusted version of the indicator must be
calculated when working with rasters. When working with vectors, see the function
adjustSpatialWeights to modify the list.w object.}
}
\value{
A named list with
 \itemize{
        \item Mean : the mean of the spatial consistency index
        \item prt05 : the 5th percentile of the spatial consistency index
        \item prt95 : the 95th percentile of the spatial consistency index
        \item samples : all the value of the spatial consistency index
        \item sum_diff : the total sum of squarred difference between observations and their neighbours
}
}
\description{
Calculate a spatial consistency index
}
\details{
This index is experimental, it aims to measure how much a clustering solution
is spatially consistent. A classification is spatially inconsistent if
neighbouring observation do not belong to the same group. See detail for
a description of its calculation

The total spatial inconsistency (*Scr*) is calculated as follow

\deqn{isp = \sum_{i}\sum_{j}\sum_{k} (u_{ik} - u_{jk})^{2} * W_{ij}}

With U the membership matrix, i an observation, k the neighbours of i and W
the spatial weight matrix This represents the total spatial inconsistency of
the solution (true inconsistency) We propose to compare this total with
simulated values obtained by permutations (simulated inconsistency). The
values obtained by permutation are an approximation of the spatial
inconsistency obtained in a random context Ratios between the true
inconsistency and simulated inconsistencies are calculated A value of 0
depict a situation where all observations are identical to their neighbours
A value of 1 depict a situation where all observations are as much different
as their neighbours that what randomness can produce A classification
solution able to reduce this index has a better spatial consistency
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
spConsistency(result$Belongings, nblistw = Wqueen, nrep=50)
}
