% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_conservation_units.R
\name{read_conservation_units}
\alias{read_conservation_units}
\title{Download spatial data of Brazilian environmental conservation units}
\usage{
read_conservation_units(date = 201909, simplified = TRUE, showProgress = TRUE)
}
\arguments{
\item{date}{Numeric. Date of the data in YYYYMM format. Defaults to \code{201909}.}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function
should return the data set with 'original' spatial resolution or a data set
with 'simplified' geometry. Defaults to \code{TRUE}. For spatial analysis and
statistics users should set \code{simplified = FALSE}. Borders have been
simplified by removing vertices of borders using \verb{st_simplify\{sf\}} preserving
topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
This data set covers the whole of Brazil and it includes the polygons of all
conservation units present in Brazilian territory. The last update of the data
was 09-2019. The original data comes from MMA and can be found at "http://mapas.mma.gov.br/i3geo/datadownload.htm".
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read conservation_units
b <- read_conservation_units(date = 201909)
\dontshow{\}) # examplesIf}
}
\seealso{
Other general area functions: 
\code{\link{read_census_tract}()}
}
\concept{general area functions}
