% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_municipality.R
\name{read_municipality}
\alias{read_municipality}
\title{Download shape files of Brazilian municipalities as sf objects.}
\usage{
read_municipality(code_muni = "all", year = NULL, tp = "simplified")
}
\arguments{
\item{code_muni}{The 7-digit code of a municipality. If the two-digit code or a two-letter uppercase abbreviation of
a state is passed, (e.g. 33 or "RJ") the function will load all municipalities of that state. If code_muni="all", all municipalities of the country will be loaded.}

\item{year}{Year of the data (defaults to 2010)}

\item{tp}{Whether the function returns the 'original' dataset with high resolution or a dataset with 'simplified' borders (Default)}
}
\description{
Data at scale 1:250,000, using Geodetic reference system "SIRGAS2000" and CRS(4674)
}
\examples{
\donttest{

library(geobr)

# Read specific municipality at a given year
  mun <- read_municipality(code_muni=1200179, year=2017)

# Read all municipalities of a state at a given year
  mun <- read_municipality(code_muni=33, year=2010)
  mun <- read_municipality(code_muni="RJ", year=2010)

# Read all municipalities of the country at a given year
  mun <- read_municipality(code_muni="all", year=2018)

}
}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_immediate_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
