\name{plot.grf}

\alias{plot.grf}

\title{Plots Variograms for Simulated Data}

\description{
  This function plots variograms for simulated geostatistical data
  generated by the function \code{\link{grf}}. 
}

\usage{
\method{plot}{grf}(x, model.line = TRUE, plot.grid = FALSE, ylim = "default", ...)
}


\arguments{
  \item{x}{an object of the class \code{grf}, typically an output of the function
    \code{\link{grf}}.  }
  \item{model.line}{logical. If \code{TRUE} the true variogram model is added to the
    plot with the sample variogram(s).  }
  \item{plot.grid}{logical. If \code{TRUE} a plot with data locations is
    also shown.  }
  \item{ylim}{limits for the y-axis. The default is the maximum value of
    the variogram among all of the simulations.  }
  \item{\dots}{further arguments to be passed to the functions
    \code{\link{variog}} and \code{\link{plot}}.  }
}

%\details{
%  Plot with sample variogram(s) for simulated data are produced.
%  True variogram model used to generate the simulations is also
%  plotted if \code{model = TRUE}. 
%  Data locations are plotted first if \code{grid = TRUE}.
%}

\value{
  A plot with the empirical variogram(s) is produced on the output device. No
  values are returned.
}

\references{
  Further information about \bold{geoR} can be found at:\cr
  \url{http://www.maths.lancs.ac.uk/~ribeiro/geoR.html}.
}

\author{
  Paulo Justiniano Ribeiro Jr. \email{Paulo.Ribeiro@est.ufpr.br}, \cr
  Peter J. Diggle \email{p.diggle@lancaster.ac.uk}.
}

%\note{ ~~further notes~~ }

\seealso{\code{\link{grf}} for simulation of Gaussian random fields,
  \code{\link{plot.variogram}} for plotting empirical variogram,
  \code{\link{variog}} for computation of empirical variograms  and
  \code{\link{plot}} for the generic plotting function.
}


\examples{
op <- par(no.readonly = TRUE)
par(mfrow=c(2,1))
sim1 <- grf(100, cov.pars=c(10, .25))
# generates simulated data
plot(sim1, plot.grid=TRUE)
#
# plots the locations and the sample true variogram model
#
par(mfrow=c(1,1))
sim2 <- grf(100, cov.pars=c(10, .25), nsim=10)
# generates 10 simulated data
plot(sim1)
# plots sample variograms for all simulations with the true model
par(op)
}

\keyword{spatial}
\keyword{dplot}
