% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensvm.grid.R
\name{gensvm.load.full.grid}
\alias{gensvm.load.full.grid}
\title{Load a large parameter grid for the GenSVM grid search}
\usage{
gensvm.load.full.grid()
}
\description{
This loads the parameter grid from the GenSVM paper. It 
consists of 342 configurations and is constructed from all possible 
combinations of the following parameter sets:

\code{p = c(1.0, 1.5, 2.0)}
\code{lambda = 2^seq(-18, 18, 2)}
\code{kappa = c(-0.9, 0.5, 5.0)}
\code{weights = c('unit', 'group')}
}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{http://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{gensvm.grid}}, \code{\link{gensvm.load.tiny.grid}}, 
\code{\link{gensvm.load.full.grid}}.
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
