% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/linear_outcome_linear_envir_interaction_mle_function.R
\name{linear.outcome.lin.envir.interaction.sds}
\alias{linear.outcome.lin.envir.interaction.sds}
\title{Function to calculate the standard deviation of y given x for linear models with linear environment interaction}
\usage{
linear.outcome.lin.envir.interaction.sds(MAF, sd_e, beta0, ES_G, ES_E,
  ES_GE, mod, True.Model, sd_y)
}
\arguments{
\item{MAF}{Minor allele Frequency}

\item{sd_e}{Standard deviation of linear environmental factor}

\item{beta0}{baseline value for the outcome}

\item{ES_G}{Genetic Effect size}

\item{ES_E}{Environment Effect size}

\item{ES_GE}{Environment x Genetic interaction Effect size}

\item{mod}{Test model}

\item{True.Model}{True model}

\item{sd_y}{Standard deviation of y}
}
\value{
The standard deviation of y given x for linear models with linear environment interaction
}
\description{
Returns the standard deviation of y given x for linear models with linear environment interaction
}
\examples{
linear.outcome.lin.envir.interaction.sds(MAF = 0.28, beta0 = -0.28, 
	sd_y = 5, sd_e = 1, ES_G = 0.5, ES_E = 1.6, ES_GE = 1.4, 
	mod = "Dominant", True.Model = "Additive")

}
