% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causeSummary2NoP.R
\name{causeSummary2NoP}
\alias{causeSummary2NoP}
\title{No Print version Kernel causality summary of evidence for causal paths 
from three criteria using new exact stochastic dominance.}
\usage{
causeSummary2NoP(mtx, nam = colnames(mtx), ctrl = 0, dig = 6)
}
\arguments{
\item{mtx}{{The data matrix with many columns, y the first column 
is fixed and then 
 paired with all columns, one by one, and still called x for the 
 purpose of flipping.}}

\item{nam}{{vector of column names for \code{mtx}. Default: colnames(mtx)}}

\item{ctrl}{{data matrix for designated control variable(s) outside causal paths}}

\item{dig}{{Number of digits for reporting (default \code{dig}=6).}}
}
\value{
If there are p columns in the input matrix, x1, x2, .., xp, say,
and if we keep x1 as a common member of all causal direction pairs
(x1, x(1+j)) for (j=1, 2, .., p-1) which can be flipped. That is, either x1 is
the cause or x(1+j) is the cause in a chosen pair.
The control
variables are not flipped. The printed output of this function
reports the results for p-1 pairs indicating which variable
(by name) causes which another variable (also by name).
It also prints a signed summary strength index in the range [-100,100]. 
A positive sign of the strength index means x1 kernel causes x(1+j),
whereas negative strength index means x(1+j) kernel causes x1. The function 
also prints Pearson correlation and its p-value. In short, function returns
a matrix of p-1 rows and 5 columns entitled: 
``cause", ``response", ``strength", ``corr." and ``p-value", respectively
with self-explanatory titles. The first two columns have names of variables
x1 or x(1+j), depending on which is the cause. The `strength' column
reports the absolute value of summary index, in the range [0,100]  
providing summary of causal results
based on preponderance of evidence from Cr1 to Cr3 
from four orders of stochastic dominance, moments, deciles
etc.  The order of input columns in mtx matters.
The fourth column `corr.' of `out' reports the Pearson correlation coefficient while
the fifth column has the p-value for testing the null of zero Pearson coeff.
This function calls  \code{silentPair2} allowing for control variables.
The output of this function can be sent to `xtable' for a nice Latex table.
}
\description{
The function develops a unanimity index regarding the which
flip (y on xi) or (xi on y) is best. Relevant signs determine the
causal direction and unanimity index among three criteria.
While allowing the researcher to keep some variables as controls,
or outside the scope of causal path determination 
(e.g., age or latitude)  this function produces detailed causal path information 
in a 5 column matrix identifying the names of variables,
causal path directions, path strengths re-scaled to be in the 
range [--100, 100], (table reports absolute values of the strength)
plus Pearson correlation and its p-value.
The `2' in the name of the function suggests a second implementation
where exact stochastic dominance, decileVote and momentVote are used
and where we avoid Anderson's trapezoidal approximation.
}
\details{
The algorithm determines causal path directions 
from the sign
of the strength index and strength index values by comparing 
three aspects of flipped kernel regressions: 
[x1 on f(x2, x3, .. xp)] and its flipped version [x2 on f(x1, x3, .. xp)]
We compare (i) formal exogeneity test criterion, (ii) absolute residuals, and
(iii) R-squares of the flipped regressions implying three criteria Cr1, to Cr3.
The criteria are quantified by newer exact methods using four orders
of stochastic dominance, SD1 to SD4. See Vinod (2021) SSRN papers. In portfolio
applications of stochastic dominance one wants higher values.  Here we are
comparing two probability distributions of absolute residuals for two
flipped models. We choose that flip which has smaller absolute residuals
which will have a better fit.
}
\note{
The European Crime data has all three criteria correctly suggesting that
high crime rate kernel causes the deployment of a large number of police officers.
Since Cr1 to Cr3 near unanimously suggest `crim' as the cause of `off', 
strength index 100 suggests unanimity among the criteria. 
\code{attach(EuroCrime); causeSummary(cbind(crim,off))}
}
\examples{


\dontrun{
mtx=as.matrix(mtcars[,1:3])
ctrl=as.matrix(mtcars[,4:5])
 causeSummary2(mtx,ctrl,nam=colnames(mtx))
}

options(np.messages=FALSE)
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10 #x is somewhat indep and affected by z
y=1+2*x+3*z+rnorm(10)
w=runif(10)
x2=x;x2[4]=NA;y2=y;y2[8]=NA;w2=w;w2[4]=NA
causeSummary2(mtx=cbind(x2,y2), ctrl=cbind(z,w2))
 

}
\references{
Vinod, H. D. 'Generalized Correlation and Kernel Causality with
   Applications in Development Economics' in Communications in
   Statistics -Simulation and Computation, 2015,
   \doi{10.1080/03610918.2015.1122048}

Vinod, H. D. 'New exogeneity tests and causal paths,'
 Chapter 2 in 'Handbook of Statistics: Conceptual Econometrics 
Using R', Vol.32, co-editors: H. D. Vinod and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2019, pp. 33-64.

Vinod, H. D. Causal Paths and Exogeneity Tests 
in {Generalcorr} Package for Air Pollution and Monetary Policy 
(June 6, 2017). Available at SSRN: 
\url{https://www.ssrn.com/abstract=2982128}

Vinod, Hrishikesh D., R Package GeneralCorr 
Functions for Portfolio Choice 
(November 11, 2021). Available at SSRN: 
https://ssrn.com/abstract=3961683

Vinod, Hrishikesh D., Stochastic Dominance 
Without Tears (January 26, 2021). Available at 
SSRN: https://ssrn.com/abstract=3773309
}
\seealso{
See  \code{\link{siPair2Blk}} for a block version

See  \code{\link{causeSummary}} is subject to trapezoidal approximation.

see \code{\link{silentPair2}} called by this function.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\concept{causal path}
\concept{stochastic dominance orders}
\concept{summary index}
