% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get0outliers.R
\name{get0outliers}
\alias{get0outliers}
\title{Function to compute outliers and their count using Tukey method
using 1.5 times interquartile range (IQR) to define boundaries.}
\usage{
get0outliers(x, verbo = TRUE, mult = 1.5)
}
\arguments{
\item{x}{{vector of data.}}

\item{verbo}{{set to TRUE(default) assuming printed details are desired.}}

\item{mult}{{=1.5(default), the number of times IQR is used 
in defining outlier boundaries.}}
}
\value{
\item{below}{which items are lower than the lower limit} 
\item{above}{which items are larger than the upper limit} 
\item{low.lim}{the lower boundary for outlier detection} 
\item{up.lim}{the upper boundary for outlier detection} 
\item{nUP}{count of number of data points above upper boundary} 
\item{nLO}{count of number of data points below lower boundary}
}
\description{
Function to compute outliers and their count using Tukey method
using 1.5 times interquartile range (IQR) to define boundaries.
}
\note{
The function removes the missing data before checking for outliers.
}
\examples{

set.seed(101);x=sample(1:100)[1:15];x[16]=150;x[17]=NA
get0outliers(x)#correctly identifies outlier=150


}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{outlier detection}
