% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessions_from_spp.R
\name{accessions_from_spp}
\alias{accessions_from_spp}
\title{Extract the accession ids (XP accession) for a given organism}
\usage{
accessions_from_spp(my_accessions, spp)
}
\arguments{
\item{my_accessions}{A data frame with accession protein ids and organisms}

\item{spp}{A string with the scientific name of the species or organism.}
}
\value{
A string vector with protein accession (XP accession, RefSeq database)
}
\description{
Filter a dataframe of protein ids and return the accessions for a given 
species or organism.
}
\examples{
my_prots = data.frame(accession = c("XP_014620925", "XP_003546066", 
   "XP_025640041", "XP_019453956", "XP_006584791", "XP_020212415", 
   "XP_017436622", "XP_004503803", "XP_019463844"),
   organism =  c("Glycine max", "Glycine max", "Arachis hypogaea",
   "Lupinus angustifolius", "Glycine max", "Cajanus cajan", 
   "Vigna angularis", "Cicer arietinum", "Lupinus angustifolius"))
   
accessions_from_spp(my_prots, "Glycine max")
 
}
\seealso{
\code{\link{getAccessions}} to create the data frame with accession 
  id and organism for each protein identifier.
}
\author{
Jose V. Die
}
