% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtor.R
\name{filter_vcf_by_gff}
\alias{filter_vcf_by_gff}
\alias{filter_vcf}
\title{Filter VCF by GFF}
\usage{
filter_vcf(vcf, gff = gff,
           mode = c("POS", "type", "both"),
           Chr = Chr, start = start, end = end,
           type = c("CDS", "exon", "gene", "genome", "custom"),
           cusTyp = c("CDS", "five_prime_UTR", "three_prime_UTR"))
}
\arguments{
\item{vcf}{object of vcfR class, VCF file imported by \code{import_vcf()}}

\item{gff}{object of GRanges class, genome annotations imported by
\code{import_gff()}}

\item{mode}{filter mode, one of "POS", "type", "both"}

\item{Chr}{chromosome name, needed if mode set to "POS" or "both"}

\item{start}{start position, needed if mode set to "POS" or "both"}

\item{end}{end position, needed if mode set to "POS" or "both"}

\item{type}{filter type, needed if mode set to "type" or "both",
one of "CDS", "exon", "gene", "genome", "custom",
if \code{type} was set to "custom", then \code{custom_type} is needed.}

\item{cusTyp}{character vector, custom filter type,
needed if \code{type} set to "custom"}
}
\value{
vcfR
}
\description{
filter VCF by GFF annotation or by position or both
}
\examples{

# filtet hap
data("geneHapR_test")
vcf_f1 <- filter_vcf(vcf, mode = "POS",
                    Chr = "scaffold_1",
                    start = 4300, end = 5890)

vcf_f2 <- filter_vcf(vcf, mode = "type",
                    gff = gff,
                    type = "CDS")
vcf_f3 <- filter_vcf(vcf, mode = "both",
                    Chr = "scaffold_1",
                    start = 4300, end = 5890,
                    gff = gff,
                    type = "CDS")

}
