/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.JumpPerturber;
import java.text.NumberFormat;
import java.util.Random;

public class SingleLogitPerturber
implements JumpPerturber {
    private String stringvalue = "";
    private NumberFormat nf;
    private final int which;
    private final int whichpoint;
    private double mss;
    private double scale = 1.0;
    private double adj = 1.0;
    static Random rand = new Random(System.currentTimeMillis());

    public SingleLogitPerturber(int which, int whichpoint, double mss) {
        this.which = which;
        this.whichpoint = whichpoint;
        this.mss = mss;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(3);
        this.nf.setGroupingUsed(false);
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        whoseTurn = this.whichpoint;
        this.scale = Math.exp(this.mss * rand.nextGaussian());
        double temp = 1.0 / (1.0 + this.scale * (1.0 - candarray[this.which][whoseTurn]) / candarray[this.which][whoseTurn]);
        this.adj = temp * (1.0 - temp) / candarray[this.which][whoseTurn] / (1.0 - candarray[this.which][whoseTurn]);
        candarray[this.which][whoseTurn] = temp;
        this.stringvalue = this.nf.format(candarray[this.which][whoseTurn]) + "";
    }

    public int numTurns() {
        return 1;
    }

    public double jacobian() {
        return this.adj;
    }

    public double density(double[][] oldarr, double[][] newarr, int whoseTurn) {
        whoseTurn = this.whichpoint;
        double temp = oldarr[this.which][whoseTurn];
        temp = Math.log(temp / (1.0 - temp));
        double temp1 = newarr[this.which][whoseTurn];
        temp1 = Math.log(temp1 / (1.0 - temp1));
        return 1.0 / Math.sqrt(Math.PI * 2) / this.mss * Math.exp(-(temp - temp1) * (temp - temp1) / 2.0 / this.mss / this.mss) / newarr[this.which][whoseTurn] / (1.0 - newarr[this.which][whoseTurn]);
    }

    public String toString() {
        return this.stringvalue;
    }
}

