/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableAdapter<E>
extends AbstractTableModel {
    private final ListModel listModel;
    private final String[] columnNames;

    public AbstractTableAdapter(ListModel listModel) {
        this(listModel, null);
    }

    public AbstractTableAdapter(ListModel listModel, String ... columnNames) {
        this.listModel = listModel;
        if (listModel == null) {
            throw new NullPointerException("The list model must not be null.");
        }
        if (columnNames == null || columnNames.length == 0) {
            this.columnNames = null;
        } else {
            this.columnNames = new String[columnNames.length];
            System.arraycopy(columnNames, 0, this.columnNames, 0, columnNames.length);
        }
        listModel.addListDataListener(this.createChangeHandler());
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public final int getRowCount() {
        return this.listModel.getSize();
    }

    public final E getRow(int index) {
        return this.listModel.getElementAt(index);
    }

    protected ListDataListener createChangeHandler() {
        return new ListDataChangeHandler();
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent evt) {
            AbstractTableAdapter.this.fireTableRowsInserted(evt.getIndex0(), evt.getIndex1());
        }

        public void intervalRemoved(ListDataEvent evt) {
            AbstractTableAdapter.this.fireTableRowsDeleted(evt.getIndex0(), evt.getIndex1());
        }

        public void contentsChanged(ListDataEvent evt) {
            int firstRow = evt.getIndex0();
            int lastRow = evt.getIndex1();
            AbstractTableAdapter.this.fireTableRowsUpdated(firstRow, lastRow);
        }
    }
}

