% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.oneclass}
\alias{gelnet.oneclass}
\title{GELnet for one-class regression}
\usage{
gelnet.oneclass(X, l1, l2, d = rep(1, p), P = diag(p), m = rep(0, p),
  max.iter = 100, eps = 1e-05, w.init = rep(0, p), silent = FALSE)
}
\arguments{
\item{X}{n-by-p matrix of n samples in p dimensions}

\item{l1}{coefficient for the L1-norm penalty}

\item{l2}{coefficient for the L2-norm penalty}

\item{d}{p-by-1 vector of feature weights}

\item{P}{p-by-p feature association penalty matrix}

\item{m}{p-by-1 vector of translation coefficients}

\item{max.iter}{maximum number of iterations}

\item{eps}{convergence precision}

\item{w.init}{initial parameter estimate for the weights}

\item{silent}{set to TRUE to suppress run-time output to stdout (default: FALSE)}
}
\value{
A list with one element:
\describe{
  \item{w}{p-by-1 vector of p model weights}
}
}
\description{
Constructs a GELnet model for one-class regression using the Newton method.
}
\details{
The function optimizes the following objective:
\deqn{ -\frac{1}{n} \sum_i s_i - \log( 1 + \exp(s_i) ) + R(w) }
 where
\deqn{ s_i = w^T x_i }
\deqn{ R(w) = \lambda_1 \sum_j d_j |w_j| + \frac{\lambda_2}{2} (w-m)^T P (w-m) }
The method operates by constructing iteratively re-weighted least squares approximations
of the log-likelihood loss function and then calling the linear regression routine
to solve those approximations. The least squares approximations are obtained via the Taylor series
expansion about the current parameter estimates.
}
\seealso{
\code{\link{gelnet.lin}}, \code{\link{gelnet.oneclass.obj}}
}

