% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trending_coins.R
\name{trending_coins}
\alias{trending_coins}
\title{Trending coins}
\usage{
trending_coins(max_attempts = 3)
}
\arguments{
\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{timestamp} (POSIXct): date and time of the API request;
\item \code{popularity_rank_24h} (integer): popularity rank in the last 24 hours;
\item \code{coin_id} (character): coin ID;
\item \code{name} (character): common name of the coin;
\item \code{symbol} (character): symbol of the coin;
\item \code{market_cap_rank} (integer): market capitalisation rank;
\item \code{price_btc} (double): price expressed in Bitcoin.
}
}
\description{
Retrieves top-7 coins on CoinGecko according to their search popularity
}
\details{
Popularity of a coin is determined from search patterns at the
CoinGecko website over the last 24 hours.

This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- trending_coins()
print(r)
}
}
