% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pid_idsa.R
\name{psd_iev}
\alias{psd_iev}
\title{PSD of an interaction of explanatory variables (PSD-IEV)}
\usage{
psd_iev(discdata, spzone, wt)
}
\arguments{
\item{discdata}{Observed data with discrete explanatory variables. A \code{tibble} or \code{data.frame} .}

\item{spzone}{Fuzzy overlay spatial zones. Returned from \code{st_fuzzyoverlay()}.}

\item{wt}{Spatial weight matrix}
}
\value{
The Value of \code{PSD-IEV}
}
\description{
PSD of an interaction of explanatory variables (PSD-IEV)
}
\details{
\eqn{\phi = 1 - \frac{\sum_{i=1}^m \sum_{k=1}^{n_i}N_{i,k}\tau_{i,k}}{\sum_{i=1}^m N_i \tau_i}}
}
\examples{
data('sim')
wt = sdsfun::inverse_distance_swm(sf::st_as_sf(sim,coords = c('lo','la')))
sim1 = dplyr::mutate(sim,dplyr::across(xa:xc,\(.x) sdsfun::discretize_vector(.x,5)))
sz = sdsfun::fuzzyoverlay(y ~ xa + xb + xc, data = sim1)
psd_iev(dplyr::select(sim1,xa:xc),sz,wt)

}
\references{
Yongze Song & Peng Wu (2021) An interactive detector for spatial associations,
International Journal of Geographical Information Science, 35:8, 1676-1701,
DOI:10.1080/13658816.2021.1882680
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
