% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_collection_ops.R
\name{translate_cog}
\alias{translate_cog}
\title{Convert complete image collections to cloud-optimized GeoTIFFs}
\usage{
translate_cog(
  collection,
  target_dir = tempfile(pattern = "image_collection_"),
  overwrite = TRUE,
  creation_options = c("BLOCKSIZE=256", "COMPRESS=DEFLTE", "LEVEL=1",
    "RESAMPLING=CUBIC")
)
}
\arguments{
\item{collection}{path to an existing image collection file}

\item{target_dir}{directory where the output will be stored, will be created if necessary}

\item{overwrite}{logical; if TRUE existing files will be overwritten}

\item{creation_options}{further settings of the GDAL COG driver; see \url{https://gdal.org/drivers/raster/cog.html}}
}
\value{
path to the new image collection file for use as argument to \code{\link{image_collection}}
}
\description{
This function translates all images of a gdalcubes image collection to cloud-optimized GeoTIFF files.
The output contains converted imagery as an additional copy (original files are not deleted) and
a new image collection file.
}
\note{
This function requires the GDAL COG driver, which was added in GDAL version 3.1.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
L8.col
\donttest{
if ("COG" \%in\% gdalcubes_gdalformats()) {
  L8.cog.col = translate_cog(L8.col)
  L8.cog.col
}
}
}
