% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcite_paper_df.R
\name{gcite_paper_df}
\alias{gcite_paper_df}
\title{Get Paper Data Frame from Title URLs}
\usage{
gcite_paper_df(urls, verbose = TRUE, force = FALSE, sleeptime = 0,
  ...)
}
\arguments{
\item{urls}{A character vector of urls, from 
\code{all_papers$title_link}}

\item{verbose}{Print diagnostic messages}

\item{force}{If passing a URL and there is a failure, should the 
program return \code{NULL}, passed to \code{\link{gcite_citation_page}}}

\item{sleeptime}{time in seconds between http requests, 
to avoid Google Scholar rate limit}

\item{...}{Additional arguments passed to \code{\link{GET}}}
}
\value{
A \code{data.frame} of authors, journal, and citations
}
\description{
Get Paper Data Frame from Title URLs
}
\examples{
if (!is_travis()) {
L = gcite_user_info(user = "uERvKpYAAAAJ", 
read_citations = FALSE)
urls = L$all_papers$title_link
paper_df = gcite_paper_df(urls = urls, force = TRUE)
} 
}
