% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_local.R
\name{gbif_local}
\alias{gbif_local}
\title{Local connection to a downloaded GBIF Parquet database}
\usage{
gbif_local(
  dir = gbif_parquet_dir(version = gbif_version(local = TRUE)),
  tblname = "gbif",
  backend = "duckdb",
  safe = TRUE
)
}
\arguments{
\item{dir}{the directory containing all parquet files to be read}

\item{tblname}{name of the table to be created in the duckdb VIEW}

\item{backend}{Use arrow or duckdb as backend connection?}

\item{safe}{logical, default TRUE.  Should we exclude columns \verb{mediatype`` and }issue`?
varchar datatype on these columns substantially slows downs queries.}
}
\value{
a remote tibble \code{tbl_sql} class object
}
\description{
Local connection to a downloaded GBIF Parquet database
}
\details{
A summary of this GBIF data, along with column meanings can be found at
\url{https://github.com/gbif/occurrence/blob/master/aws-public-data.md}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}


gbif <- gbif_local(gbif_example_data())
\dontshow{\}) # examplesIf}
}
