% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsdiag.R
\name{tsdiag.garma_model}
\alias{tsdiag.garma_model}
\title{Diagnostic fit of a garma_model.}
\usage{
\method{tsdiag}{garma_model}(object, gof.lag = 10, ...)
}
\arguments{
\item{object}{(garma_model) The garma_model to produce the diagnostic plots for.}

\item{gof.lag}{(int) The number of lags to examine for the Ljung-Box white noise test.}

\item{...}{further arguments to be passed to particular methods.}
}
\value{
None. Diagnostics are generated.
}
\description{
Produces diagnostic plots of the model fit.
This function is copied from stats::tsdiag but modifies the fit_df for the Ljung-Box test for use with garma models.
}
\examples{
data(AirPassengers)
ap <- as.numeric(diff(AirPassengers, 12))
mdl <- garma(ap, order = c(9, 1, 0), k = 0, method = "CSS", include.mean = FALSE)
tsdiag(mdl)
}
\seealso{
The stats package tsdiag function: \url{https://stat.ethz.ch/R-manual/R-patched/library/stats/html/tsdiag.html}.
}
