% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl2dplot.R
\name{qtl2dplot}
\alias{qtl2dplot}
\title{2D QTL plot}
\usage{
qtl2dplot(
  d,
  chrlen = gap::hg19,
  snp_name = "SNP",
  snp_chr = "Chr",
  snp_pos = "bp",
  gene_chr = "p.chr",
  gene_start = "p.start",
  gene_end = "p.end",
  trait = "p.target.short",
  gene = "p.gene",
  TSS = FALSE,
  cis = "cis",
  value = "log10p",
  plot = TRUE,
  cex.labels = 0.6,
  cex.points = 0.6,
  xlab = "QTL position",
  ylab = "Gene position"
)
}
\arguments{
\item{d}{Data to be used.}

\item{chrlen}{lengths of chromosomes for specific build: hg18, hg19, hg38.}

\item{snp_name}{variant name.}

\item{snp_chr}{variant chromosome.}

\item{snp_pos}{variant position.}

\item{gene_chr}{gene chromosome.}

\item{gene_start}{gene start position.}

\item{gene_end}{gene end position.}

\item{trait}{trait name.}

\item{gene}{gene name.}

\item{TSS}{to use TSS when TRUE.}

\item{cis}{cis variant when TRUE.}

\item{value}{A specific value to show.}

\item{plot}{to plot when TRUE.}

\item{cex.labels}{Axis label extension factor.}

\item{cex.points}{Data point extension factor.}

\item{xlab}{X-axis title.}

\item{ylab}{Y-axis title.}
}
\value{
positional information.
}
\description{
This function is both used as its own for a 2d plot and/or generate data for a plotly counterpart.
}
\examples{
\dontrun{
INF <- Sys.getenv("INF")
d <- read.csv(file.path(INF,"work","INF1.merge.cis.vs.trans"),as.is=TRUE)
r <- qtl2dplot(d)
}
}
