% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooths.R
\name{s}
\alias{s}
\alias{sl}
\title{Set up smooth term with factor loading}
\usage{
sl(..., factor = NULL)
}
\arguments{
\item{...}{Arguments passed on to \code{mgcv::s}.}

\item{factor}{Optional character argument specifying the loading variable.
Case sensitive.}
}
\value{
An object of class \code{xx.smooth.spec}, where \code{xx} is a basis
identifying code given by the \code{bs} argument of \code{s}. It differs
from the smooth returned by \code{mgcv::s} in that it has an additional
attribute named \code{"factor"} which specifies any factor loading which
this smooth term should be multiplied with in order to produce the observed
outcome.
}
\description{
This is a very thin wrapper around \code{mgcv::s}. It enables
the specification of loading variables for smooth terms. The last letter "l",
which stands for "loading", has been added to avoid namespace conflicts with
\code{mgcv} and \code{gamm4}.
}
\details{
The documentation of the function \code{mgcv::s} should be consulted
for details on how to properly set up smooth terms. In particular, note
that these terms distinguish between ordered and unordered factor terms
in the \code{by} variable, which can be provided in \code{...} and is
forwarded to \code{mgcv::s}.
}
\examples{
# Linear mixed model with factor structures
dat <- subset(cognition, domain == 1 & timepoint == 1)
loading_matrix <- matrix(c(1, NA, NA), ncol = 1)


# Model with four thin-plate regression splines as basis functions
mod <- galamm(
  formula = y ~ 0 + item + sl(x, k = 4, factor = "loading"),
  data = dat,
  load_var = "item",
  lambda = loading_matrix,
  factor = "loading"
)

# Model with four cubic regression splines as basis functions
mod <- galamm(
  formula = y ~ 0 + item +
    sl(x, bs = "cr", k = 4, factor = "loading"),
  data = dat,
  load_var = "item",
  lambda = loading_matrix,
  factor = "loading"
)

}
\references{
\insertRef{woodThinPlateRegression2003}{galamm}

\insertRef{woodGeneralizedAdditiveModels2017}{galamm}
}
\seealso{
Other modeling functions: 
\code{\link{galamm}()},
\code{\link{galammObject}},
\code{\link{gfam}()},
\code{\link{t2}()}
}
\concept{modeling functions}
