% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_media.R
\name{search_media}
\alias{search_media}
\title{Search for associated media of occurrence records}
\usage{
search_media(df)
}
\arguments{
\item{df}{A \code{tibble} of species occurrence records or media IDs.}
}
\value{
a \code{tibble} of matching media files of occurrence records or media ids
}
\description{
Search for media files for a set of occurrence records
downloaded using \code{\link[=atlas_occurrences]{atlas_occurrences()}}. \code{search_media()} also accepts
a set of media IDs (parsed or unparsed).
}
\section{Examples}{


Search for media files associated with a specified set of
species occurrence records

\if{html}{\out{<div class="sourceCode r">}}\preformatted{occs <- galah_call() |>
  galah_identify("perameles") |>
  galah_filter(year == 2001) |>
  atlas_occurrences()
  
search_media(occs)
}\if{html}{\out{</div>}}
}

