% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ala_occurrences.R
\name{ala_occurrences}
\alias{ala_occurrences}
\title{Occurrence records}
\usage{
ala_occurrences(taxa, filters, locations, columns, mint_doi = FALSE, doi)
}
\arguments{
\item{taxa}{\code{data.frame}: generated by a call to \code{\link{select_taxa}()}. This
argument also accepts a vector of unique species identifiers.}

\item{filters}{\code{data.frame}: generated by a call to \code{\link{select_filters}()}}

\item{locations}{\code{string}: generated by a call to \code{\link{select_locations}()}}

\item{columns}{\code{data.frame}: generated by a call to \code{\link{select_columns}()}}

\item{mint_doi}{\code{logical}: by default no DOI will be generated. Set to
true if you intend to use the data in a publication or similar}

\item{doi}{\code{string}: this argument enables retrieval of occurrence
records previously downloaded from the ALA, using the DOI generated by the data.
Specifying this argument means all other arguments will be ignored.}
}
\value{
A \code{data.frame} of occurrences, columns as specified
by \code{\link{select_columns}()}.
}
\description{
The most common form of data stored by ALA are observations of
individual life forms, known as 'occurrences'. This function allows the
user to search for occurrence records that match their specific criteria,
and return them as a \code{data.frame} for analysis. Optionally,
the user can also request a DOI for a given download to facilitate citation and
re-use of specific data resources.
}
\details{
Note that unless care is taken, some queries can be particularly large.
While most cases this will simply take a long time to process, if the number
of requested records is >50 million the call will not return any data. Users
can test whether this threshold will be reached by first calling
\code{\link{ala_counts}()} using the same arguments that they intend to pass to
\code{ala_occurrences}(). It may also be beneficial when requesting a large
number of records to show a progress bar by setting \code{verbose = TRUE} in
\code{\link{ala_config}()}.
}
\examples{
\dontrun{
# Search for occurrences matching a taxon identifier
occ <- ala_occurrences(taxa = select_taxa("Reptilia"))

# Search for occurrences in a year range
occ <- ala_occurrences(filters = select_filters(year = seq(2010, 2020)))

# Search for occurrences in a WKT-specified area
polygon <- "POLYGON((146.24960 -34.05930,146.37045 -34.05930,146.37045 \
-34.152549,146.24960 -34.15254,146.24960 -34.05930))"
occ <- ala_occurrences(locations = select_locations(polygon))
}
}
