% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_fit_center}
\alias{g6_fit_center}
\title{Center graph}
\usage{
g6_fit_center(graph, animation = NULL)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{animation}{Optional list containing animation configuration parameters for the focus action.
Common parameters include:
\itemize{
\item \code{duration}: Duration of the animation in milliseconds.
\item \code{easing}: Animation easing function name (e.g., "ease-in", "ease-out").
}
If NULL, no animation will be applied.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function pans the graph to the center of the viewport
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

See \url{https://g6.antv.antgroup.com/en/api/viewport#graphfitcenteranimation} for more details.
}
\seealso{
\code{\link{g6_proxy}}
}
