% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{TWAPLS.w}
\alias{TWAPLS.w}
\title{TWA-PLS training function}
\usage{
TWAPLS.w(modern_taxa, modern_climate, nPLS = 5, usefx = FALSE, fx = NA)
}
\arguments{
\item{modern_taxa}{the modern taxa abundance data, each row represents a
sampling site, each column represents a taxon.}

\item{modern_climate}{the modern climate value at each sampling site}

\item{nPLS}{the number of components to be extracted}

\item{usefx}{boolean flag on whether or not use \code{fx} correction.}

\item{fx}{the frequency of the climate value for \code{fx} correction: if
\code{usefx} is FALSE, this should be \code{NA}; otherwise, this should
be obtained from the \code{\link{fx}} function.}
}
\value{
a list of the training results, which will be used by the predict
function. fit is the fitted value of modern training result.
}
\description{
TWA-PLS training function, which can perform \code{fx} correction
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")
                                      
# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Get the frequency of each climate variable fx
fx_Tmin <- fxTWAPLS::fx(modern_pollen$Tmin, bin = 0.02)
fx_gdd <- fxTWAPLS::fx(modern_pollen$gdd, bin = 20)
fx_alpha <- fxTWAPLS::fx(modern_pollen$alpha, bin = 0.002)

# MTCO
fit_t_Tmin <- fxTWAPLS::TWAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
fit_tf_Tmin <- fxTWAPLS::TWAPLS.w(taxa, 
                                  modern_pollen$Tmin, 
                                  nPLS = 5, 
                                  usefx = TRUE, 
                                  fx = fx_Tmin)
}

}
\seealso{
\code{\link{fx}}, \code{\link{TWAPLS.predict.w}}, and
\code{\link{WAPLS.w}}
}
