% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\title{Create a cluster future whose value will be resolved asynchronously in a parallel process}
\usage{
cluster(expr, envir = parent.frame(), substitute = TRUE,
  lazy = FALSE, seed = NULL, globals = TRUE, persistent = FALSE,
  workers = availableWorkers(), user = NULL, revtunnel = TRUE,
  homogeneous = TRUE, gc = FALSE, earlySignal = FALSE,
  label = NULL, ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{lazy}{If \code{FALSE} (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{seed}{(optional) A L'Ecuyer-CMRG RNG seed.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link{future}()}.}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{workers}{A \code{\link[parallel:makeCluster]{cluster}} object,
a character vector of host names, a positive numeric scalar,
or a function.
If a character vector or a numeric scalar, a \code{cluster} object
is created using \code{\link{makeClusterPSOCK}(workers)}.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return any of the above types.}

\item{user}{(optional) The user name to be used when communicating
with another host.}

\item{revtunnel}{If TRUE, reverse SSH tunneling is used for the
PSOCK cluster nodes to connect back to the master \R process.  This
avoids the hassle of firewalls, port forwarding and having to know
the internal / public IP address of the master \R session.}

\item{homogeneous}{If TRUE, all cluster nodes is assumed to use the
same path to \file{Rscript} as the main \R session.  If FALSE, the
it is assumed to be on the PATH for each node.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some types of futures ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{label}{An optional character string label attached to the future.}

\item{\dots}{Additional named elements passed to \code{\link{ClusterFuture}()}.}
}
\value{
A \link{ClusterFuture}.
}
\description{
A cluster future is a future that uses cluster evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.
}
\details{
This function will block if all available \R cluster nodes are
occupied and will be unblocked as soon as one of the already
running cluster futures is resolved.

The preferred way to create an cluster future is not to call
this function directly, but to register it via
\code{\link{plan}(cluster)} such that it becomes the default
mechanism for all futures.  After this \code{\link{future}()}
and \code{\link{\%<-\%}} will create \emph{cluster futures}.
}
\examples{
\donttest{

## Use cluster futures
cl <- parallel::makeCluster(2L, timeout = 60)
plan(cluster, workers = cl)

## A global variable
a <- 0

## Create multicore future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A cluster future is evaluated in a separate process.
## Changing the value of a global variable will not
## affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## CLEANUP
parallel::stopCluster(cl)

}
}
