% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_by.R
\name{future_by}
\alias{future_by}
\title{Apply a Function to a Data Frame Split by Factors via Futures}
\usage{
future_by(data, INDICES, FUN, ..., simplify = TRUE)
}
\arguments{
\item{data}{An \R object, normally a data frame, possibly a matrix.}

\item{INDICES}{A factor or a list of factors, each of length \code{nrow(data)}.}

\item{FUN}{a function to be applied to (usually data-frame) subsets of \code{data}.}

\item{simplify}{logical: see \link[base:tapply]{base::tapply}.}

\item{\ldots}{Additional arguments pass to \code{\link[=future_lapply]{future_lapply()}} and
then to \code{FUN()}.}
}
\value{
An object of class "by", giving the results for each subset.
This is always a list if simplify is false, otherwise a list
or array (see \link[base:tapply]{base::tapply}).
See also \code{\link[base:by]{base::by()}} for details.
}
\description{
Apply a Function to a Data Frame Split by Factors via Futures
}
\details{
Internally, \code{data} is grouped by \code{INDICES} into a list of \code{data}
subset elements which is then processed by \code{\link[=future_lapply]{future_lapply()}}.
When the groups differ significantly in size, the processing time
may differ significantly between the groups.
To correct for processing-time imbalances, adjust the amount of chunking
via arguments \code{future.scheduling} and \code{future.chunk.size}.
}
\examples{
## ---------------------------------------------------------
## by()
## ---------------------------------------------------------
library(datasets) ## warpbreaks
library(stats)    ## lm()

y0 <- by(warpbreaks, warpbreaks[,"tension"],
         function(x) lm(breaks ~ wool, data = x))

plan(multiprocess)
y1 <- future_by(warpbreaks, warpbreaks[,"tension"],
                function(x) lm(breaks ~ wool, data = x))

plan(sequential)
y2 <- future_by(warpbreaks, warpbreaks[,"tension"],
                function(x) lm(breaks ~ wool, data = x))
}
