% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionCaption.R
\name{fusionCaption}
\alias{fusionCaption}
\title{Adding FusionCharts caption}
\usage{
fusionCaption(
  fusionPlot,
  caption = "Add a caption here",
  captionFont = "Arial",
  captionFontSize = "18",
  captionFontColor = "#5A5A5A",
  captionFontBold = TRUE,
  captionOnTop = TRUE,
  captionAlignment = c("center", "left", "right")
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{caption}{Specify the caption of the chart}

\item{captionFont}{Set the caption font family}

\item{captionFontSize}{Set the caption font size (between 0 and 72)}

\item{captionFontColor}{Set the caption font color}

\item{captionFontBold}{Enable caption font to bold}

\item{captionOnTop}{Display the caption at the top of the chart}

\item{captionAlignment}{Specify the horizontal alignment of the caption}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/caption-and-sub-caption}
}
\examples{
library(fusionchartsR)

mtcars \%>\%
fusionPlot(
x = "cyl", 
y = "mpg", 
type = "boxandwhisker2d"
) \%>\%
fusionCaption(caption = "Caption on the left", captionAlignment = "left") \%>\%
fusionSubcaption(subcaption = "subcaption too") \%>\%
fusionPalette(palettecolors = c("#5D62B5", "#979AD0")) \%>\%
fusionTheme(theme = "fusion") 

}
