% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{plot_interactive_dependency_graph}
\alias{plot_interactive_dependency_graph}
\title{Plot an interactive dependency graph}
\usage{
plot_interactive_dependency_graph(dep_info, include_disconnected = TRUE)
}
\arguments{
\item{dep_info}{List. Output from \code{\link{analyze_internal_dependencies_multi}}
containing dependency information and function metadata.}

\item{include_disconnected}{Logical. If \code{FALSE}, excludes nodes that are
not connected to the center node (most-connected function). Default is
\code{TRUE}.}
}
\value{
A \code{visNetwork} HTML widget displaying the interactive dependency
graph. The widget can be displayed in RStudio Viewer, web browser, or saved
to HTML using \code{htmlwidgets::saveWidget()}.
}
\description{
Creates an interactive network visualization of function dependencies using
\code{visNetwork}. Nodes represent functions and edges represent function calls.
The graph uses hierarchical layout with color-coding based on distance from
the most-connected function.
}
\details{
The visualization includes:
\itemize{
\item \strong{Node colors}: Functions are color-coded by their distance
(number of hops) from the most-connected function
\item \strong{Node shapes}: Boxes for defined functions, ellipses for
undefined/external functions
\item \strong{Tooltips}: Hover over nodes to see function arguments, return
values, source file, and documentation
\item \strong{Interactive controls}: Zoom, pan, drag nodes, and navigation
buttons
}

The center node (most-connected function) is fixed at position (0,0) and
rendered in dark red. Other nodes are positioned using a force-directed layout.
}
\examples{
# Create temporary R files with sample code
temp_file <- tempfile(fileext = ".R")
writeLines(c(
  "helper_function <- function(x) { x * 2 }",
  "main_function <- function(a) { helper_function(a) + 1 }",
  "another_function <- function(b) { main_function(b) }"
), temp_file)

# Analyze the file
dep_info <- analyze_internal_dependencies_multi(temp_file)

# Create interactive graph
graph <- plot_interactive_dependency_graph(dep_info)

# Show only connected components
graph <- plot_interactive_dependency_graph(dep_info,
                                           include_disconnected = FALSE)

# Clean up
unlink(temp_file)
}
