% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beales.R
\name{beales}
\alias{beales}
\title{Beale's Estimator and Sample Size}
\usage{
beales(x, y, level = 0.95, N = NULL, p = NULL, d = NULL, verbose = TRUE)
}
\arguments{
\item{x}{a numeric vector with quantities of interest, such as river discharge
per month. Missing values (\code{NA}) are allowed.}

\item{y}{a numeric vector with quantities of interest for which the total shall
be estimated, such as total nutrient loads per month.
Missing values (\code{NA}) are allowed.
Lengths of \code{x} and \code{y} mush be the same.}

\item{level}{confidence level, from 0 to 1.
Default is \code{0.95}, that is, 95\% confidence.}

\item{N}{population size for which the estimate of the total \code{y} is required.
By default, \code{length(x)} is used.}

\item{p}{optional argument specifying the required relative error, from 0 to 1,
for computing the corresponding sample size. For example, \code{p = 0.15} defines
a 15\% relative error.}

\item{d}{optional argument specifying the required margin of error
for computing the corresponding sample size. If both \code{p} and \code{d} are specified,
only \code{p} is used.}

\item{verbose}{logical value defining whether the output should be printed out
in words. Default is set to \code{TRUE} to give such output.}
}
\value{
A list with the following components:
\item{estimate}{Beale's estimate of the population total for the variable \code{y}.}
\item{se}{standard error of the estimate.}
\item{CI}{a vector of length 2 with a confidence interval (lower and upper value)
for the estimate.}
\item{level}{confidence level for the interval.}
\item{N}{population size.}
\item{n}{the actual sample size.}
\item{p}{the relative error used for sample size calculations.
Reported only if \code{p} was specified in the input.}
\item{d}{the margin of error used for sample size calculations.
Reported only if \code{d} was specified and \code{p} was not specified in the input.}
\item{nhat}{estimated sample size for the given \code{level} and error
(\code{p} or \code{d}).}
}
\description{
Beale's ratio estimator \insertCite{Beale_1962}{funtimes}
for estimating population total and
confidence intervals, with an option of calculating sample size for a required
relative error (\code{p}) or margin of error (\code{d}).
}
\examples{
#Some hypothetical data for monthly river discharge 
#and corresponding nutrient loads:
discharge <- c(NA, 50, 90, 100, 80, 90, 100, 90, 80, 70, NA, NA)
loads <- c(33, 22, 44, 48, NA, 44, 49, NA, NA, 36, NA, NA)

#Example 1:
#Estimate total annual load (12 months), 
#with 90\% confidence intervals
beales(discharge, loads, level = 0.9)

#Example 2:
#Calculate sample size required for 90\% confidence intervals 
#with a margin of error 30 units
beales(discharge, loads, level = 0.9, d = 30)

}
\references{
\insertAllCited{}
}
\seealso{
\code{vignette("beales", package = "funtimes")}
}
\author{
Vyacheslav Lyubchich, thanks to Dave Lorenz for pointing out an error in version 7 and below of the package
}
\keyword{power}
\keyword{sample}
\keyword{ts}
