% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuePolyReg_test.R
\name{AuePolyReg_test}
\alias{AuePolyReg_test}
\title{Testing for Change Points in Time Series via Polynomial Regression}
\usage{
AuePolyReg_test(
  y,
  a.order,
  alpha = 0.05,
  crit.type = c("asymptotic", "bootstrap"),
  bootstrap.method = c("nonparametric", "parametric"),
  num.bootstrap = 1000
)
}
\arguments{
\item{y}{a vector that contains univariate time series observations. Missing values are
not allowed.}

\item{a.order}{order of the autoregressive model which must be a nonnegative integer number.}

\item{alpha}{significance level for testing hypothesis of no change point. Default value
is 0.05.}

\item{crit.type}{method of obtaining critical values: "asymptotic" (default) or "bootstrap".}

\item{bootstrap.method}{type of bootstrap if \code{crit.type = "bootstrap"}: "nonparametric"
(default) or "parametric".}

\item{num.bootstrap}{number of bootstrap replications if \code{crit.type = "bootstrap"}.
Default number is 1000.}
}
\value{
A list with the following components:
\item{index}{time point where the change point has occurred.}
\item{stat}{test statistic.}
\item{crit.val}{critical region value (CV(alpha, n)).}
\item{p.value}{\code{p-value} of the change point test.}
}
\description{
The function uses a nonlinear polynomial regression model in which it tests for the null
hypothesis of structural stability in the regression parameters against the alternative of
a break at an unknown time. The method is based on the extreme value distribution of a
maximum-type test statistic which is asymptotically equivalent to the maximally selected
likelihood ratio. The resulting testing approach is easily tractable and delivers accurate
size and power of the test, even in small samples \insertCite{Aue_etal_2008}{funtimes}.
}
\examples{
\dontrun{
#Example 1:

#Simulate some time series:
set.seed(23450)
series_1 = rnorm(137, 3, 5)
series_2 = rnorm(213, 0, 1)
series_val = c(series_1, series_2)
AuePolyReg_test(series_1, 1) # no change (asymptotic)
AuePolyReg_test(series_val,1) # one change (asymptotic)

#Example 2:

#Consider a time series with annual number of world terrorism incidents from 1970 till 2016:
c.data = Ecdat::terrorism["incidents"]
incidents.ts <- ts(c.data, start = 1970, end = 2016)

#Run a test for change points:
AuePolyReg_test(incidents.ts, 2) # one change (asymptotic)
AuePolyReg_test(incidents.ts, 2, 0.05,"bootstrap", "parametric", 200) 
# one change (bootstrap)
incidents.ts[44] #number of victims at the value of change point
year <- 197 + 44 - 1  # year when the change point occurred
plot(incidents.ts) # see the visualized data

#The structural change point occurred at the 44th value which corresponds to 2013, 
#with 11,990 identified incidents in that year. These findings can be explained with 
#a recent rise of nationalism and  extremism due to appearance of the social media, 
#Fisher (2019): White Terrorism Shows 'Stunning' Parallels to Islamic State's Rise. 
#The New York Times.
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mcusum.test}} change point test for regression
}
\author{
Palina Niamkova, Dorcas Ofori-Boateng, Yulia R. Gel
}
\keyword{changepoint}
\keyword{ts}
