% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_fof_pc.R
\name{fof_pc}
\alias{fof_pc}
\title{Function-on-function linear regression based on principal components}
\usage{
fof_pc(
  mfdobj_y,
  mfdobj_x,
  tot_variance_explained_x = 0.95,
  tot_variance_explained_y = 0.95,
  tot_variance_explained_res = 0.95,
  components_x = NULL,
  components_y = NULL,
  type_residuals = "standard"
)
}
\arguments{
\item{mfdobj_y}{A multivariate functional data object of class
mfd denoting the functional response variable.
Although it is a multivariate functional data object, it must
have only one functional variable.}

\item{mfdobj_x}{A multivariate functional data object of class
mfd denoting the functional covariates.}

\item{tot_variance_explained_x}{The minimum fraction of variance
that has to be explained
by the multivariate functional principal components retained into
the MFPCA model fitted on the functional covariates.
Default is 0.95.}

\item{tot_variance_explained_y}{The minimum fraction of variance that
has to be explained
by the multivariate functional principal components retained into
the MFPCA model fitted on the functional response.
Default is 0.95.}

\item{tot_variance_explained_res}{The minimum fraction of variance
that has to be explained
by the multivariate functional principal components retained into
the MFPCA model fitted on the functional residuals
of the functional regression model.
Default is 0.95.}

\item{components_x}{A vector of integers with the components over which
to project the functional covariates.
If NULL, the first components that explain a minimum fraction of variance
equal to \code{tot_variance_explained_x}
is selected.
#' If this is not NULL, the criteria to select components are ignored.
Default is NULL.}

\item{components_y}{A vector of integers with the components over which
to project the functional response.
If NULL, the first components that explain a minimum fraction of variance
equal to \code{tot_variance_explained_y}
is selected.
#' If this is not NULL, the criteria to select components are ignored.
Default is NULL.}

\item{type_residuals}{A character value that can be
"standard" or "studentized".
If "standard", the MFPCA on functional residuals is calculated on
the standardized covariates and response.
If "studentized", the MFPCA on studentized version of
the functional residuals is calculated on the
non-standardized covariates and response.
See Centofanti et al. (2021) for additional details.}
}
\value{
A list containing the following arguments:
\itemize{
\item \code{mod}: an object of class \code{lm} that is a linear regression model
where
the response variables are the MFPCA scores of the response variable and
the covariates are the MFPCA scores of the functional covariates.
\code{mod$coefficients} contains the matrix of coefficients
of the functional regression basis functions,
\item \code{beta_fd}: a \code{bifd} object containing the
bivariate functional regression coefficients \eqn{\beta(s,t)}
estimated with the function-on-function linear regression model,
\item \code{fitted.values}: a multivariate functional data object of
class mfd with the fitted values of the
functional response observations based on the
function-on-function linear regression model,
\item \code{residuals_original_scale}: a multivariate functional data object
of class mfd
with the functional residuals of the
function-on-function linear regression model on the original scale,
i.e. they are the difference between
\code{mfdobj_y} and \code{fitted.values},
\item \code{residuals}: a multivariate functional data object of class mfd
with the functional residuals of the
function-on-function linear regression model,
standardized or studentized depending on
the argument \code{type_residuals},
\item \code{type_residuals}: the same as the provided argument,
\item \code{pca_x}: an object of class \code{pca_mfd}
obtained by doing MFPCA on the functional covariates,
\item \code{pca_y}: an object of class \code{pca_mfd}
obtained by doing MFPCA on the functional response,
\item \code{pca_res}: an object of class \code{pca_mfd}
obtained by doing MFPCA on the functional residuals,
\item \code{components_x}: a vector of integers
with the components selected in the \code{pca_x} model,
\item \code{components_y}: a vector of integers
with the components selected in the \code{pca_y} model,
\item \code{components_res}: a vector of integers
with the components selected in the \code{pca_res} model,
\item \code{y_standardized}: the standardized functional response
obtained doing \code{scale_mfd(mfdobj_y)},
\item \code{tot_variance_explained_x}: the same as the provided argument
\item \code{tot_variance_explained_y}: the same as the provided argument
\item \code{tot_variance_explained_res}: the same as the provided argument
\item \code{get_studentized_residuals}: a function that allows
to calculate studentized residuals on new data,
given the estimated function-on-function linear regression model.
}
}
\description{
Function-on-function linear regression based on
principal components.
This function performs multivariate functional principal component analysis
(MFPCA)
to extract multivariate functional principal components
from the multivariate functional covariates as well as from the
functional response, then it builds a linear regression model
of the response scores on the
covariate scores.
Both functional covariates and response are standardized before
the regression.
See Centofanti et al. (2021) for additional details.
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[1:10, , drop = FALSE])
fun_covariates <- c("CO", "temperature")
mfdobj <- get_mfd_list(air, lambda = 1e-2)
mfdobj_y <- mfdobj[, "NO2"]
mfdobj_x <- mfdobj[, fun_covariates]
mod <- fof_pc(mfdobj_y, mfdobj_x)

}
\references{
Centofanti F, Lepore A, Menafoglio A, Palumbo B, Vantini S. (2021)
Functional Regression Control Chart.
\emph{Technometrics}, 63(3), 281--294. \url{doi:10.1080/00401706.2020.1753581}
}
