% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{inprod_mfd}
\alias{inprod_mfd}
\title{Inner products of functional data contained in \code{mfd} objects.}
\usage{
inprod_mfd(mfdobj1, mfdobj2 = NULL)
}
\arguments{
\item{mfdobj1}{A multivariate functional data object of class \code{mfd}.}

\item{mfdobj2}{A multivariate functional data object of class \code{mfd}.
It must have the same functional variables as \code{mfdobj1}.
If NULL, it is equal to \code{mfdobj1}.}
}
\value{
a three-dimensional array of \emph{L^2} inner products.
The first dimension is the number of functions in argument mfdobj1,
the second dimension is the same thing for argument mfdobj2,
the third dimension is the number of functional variables.
If you sum values over the third dimension,
you get a matrix of inner products
in the product Hilbert space of multivariate functional data.
}
\description{
Inner products of functional data contained in \code{mfd} objects.
}
\details{
Note that \emph{L^2} inner products are not calculated
for couples of functional data
from different functional variables.
This function is needed to calculate the
inner product in the product Hilbert space
in the case of multivariate functional data,
which for each observation is the sum of the \emph{L^2}
inner products obtained for each functional variable.
}
\examples{
library(funcharts)
mfdobj1 <- data_sim_mfd(seed = 123)
mfdobj2 <- data_sim_mfd(seed = 987)
inprod_mfd(mfdobj1)
inprod_mfd(mfdobj1, mfdobj2)
}
