% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_fgpm_Class.R
\name{update,fgpm-method}
\alias{update,fgpm-method}
\title{Easy update of \code{fgpm} models}
\usage{
\S4method{update}{fgpm}(
  object,
  sIn.nw = NULL,
  fIn.nw = NULL,
  sOut.nw = NULL,
  sIn.sb = NULL,
  fIn.sb = NULL,
  sOut.sb = NULL,
  ind.sb = NULL,
  ind.dl = NULL,
  var.sb = NULL,
  ls_s.sb = NULL,
  ls_f.sb = NULL,
  var.re = FALSE,
  ls_s.re = FALSE,
  ls_f.re = FALSE,
  extend = FALSE,
  trace = TRUE,
  pbars = TRUE,
  control.optim = list(trace = TRUE),
  ...
)
}
\arguments{
\item{object}{An object of class \linkS4class{fgpm} corresponding to the funGp model to update.}

\item{sIn.nw}{An optional matrix of scalar input values to be added to the model. Each column must match
an input variable and each row a scalar coordinate.}

\item{fIn.nw}{An optional list of functional input values to be added to the model. Each element of the
list must be a matrix containing the set of curves corresponding to one functional input.}

\item{sOut.nw}{An optional vector (or 1-column matrix) containing the values of the scalar output at the
new input points.}

\item{sIn.sb}{An optional matrix of scalar input values to be used as substitutes of other scalar input
values already stored in the model. Each column must match an input variable and each row a coordinate.}

\item{fIn.sb}{An optional list of functional input values to be added to the model. Each element of the
list must be a matrix containing the set of curves corresponding to one functional input.}

\item{sOut.sb}{An optional vector (or 1-column matrix) containing the values of the scalar output at the
substituting input points.}

\item{ind.sb}{An optional numeric array indicating the indices of the input and output points stored in
the model, that should be replaced by the values specified through sIn.sb, fIn.sb and/or sOut.sb.}

\item{ind.dl}{An optional numeric array indicating the indices of the input and output points stored in
the model that should be deleted.}

\item{var.sb}{An optional number indicating the value that should be used to substitute the current
variance parameter of the model.}

\item{ls_s.sb}{An optional numerical array indicating the values that should be used to substitute the
current length-scale parameters for the scalar inputs of the model.}

\item{ls_f.sb}{An optional numerical array indicating the values that should be used to substitute the
current length-scale parameters for the functional inputs of the model.}

\item{var.re}{An optional boolean indicating whether the variance parameter should be re-estimated.
Default is FALSE.}

\item{ls_s.re}{An optional boolean indicating whether the length-scale parameters of the scalar inputs
should be re-estimated. Default is FALSE.}

\item{ls_f.re}{An optional boolean indicating whether the length-scale parameters of the functional
inputs should be re-estimated. Default is FALSE.}

\item{extend}{An optional boolean indicating whether the re-optimization should extend from the current
hyperparameters of the model using them as initial points. Default is FALSE, meaning that the
re-optimization picks brand new initial points in the way described in \code{\link[funGp]{fgpm}()}. If
both hyperparameter substitution and re-estimation are requested in a single \code{update()} call and
\code{extend} is set to \code{TRUE}, the values used as initial points for the re-optimization are those
stored by the model after the substitution step.}

\item{trace}{An optional boolean indicating whether funGp-native progress messages and a summary update
should be displayed. Default is TRUE. See the \code{\link[funGp]{fgpm}()} documentation for more details.}

\item{pbars}{An optional boolean indicating whether progress bars managed by \code{\link[funGp]{fgpm}()}
should be displayed (in case the update requires an \code{\link[funGp]{fgpm}()} call). Default is TRUE.
See the \code{\link[funGp]{fgpm}()} documentation for more details.}

\item{control.optim}{An optional list to be passed as the control argument to \code{\link[stats]{optim}}()
(in case the update requires an \code{\link[funGp]{fgpm}()} call), the function in charge of the non-linear
optimization of the hyperparameters. Default is list(trace = TRUE). See the \code{\link[funGp]{fgpm}()}
documentation for more details.}

\item{...}{Not used.}
}
\value{
An object of class \linkS4class{fgpm} representing the updated funGp model.
}
\description{
This method enables the update of data or hyperparameters of a \code{fgpm} model.
  It corresponds to an object of the class \linkS4class{fgpm}. The method allows addition, subtraction
  and substitution of data points, as well as substitution and re-estimation of hyperparameters.
}
\details{
The arguments listed above enable the completion of the following updating tasks:
\itemize{
 \item \strong{Deletion} of data points: ind.dl;
 \item \strong{Addition} of data points: sIn.nw, fIn.nw, sOut.nw;
 \item \strong{Substitution} of data points: sIn.sb, fIn.sb, sOut.sb, ind.sb;
 \item \strong{Substitution} of hyperparameters: var.sb, ls_s.sb, ls_f.sb;
 \item \strong{Re-estimation} of hyperparameters: var.re, ls_s.re, ls_f.re.
}

All the arguments listed above are optional since any of these tasks can be requested without need to
request any of the other tasks. In fact, most of the arguments can be used even if the other
arguments related to the same task are not. For instance, the re-estimation of the variance can be
requested via var.re without requiring re-estimation of the scalar or functional length-scale
parameters. The only two exceptions are: (i) for data addition, the new output sOut.nw should always
be provided and the new input points should correspond to the set of variables already stored in the
\linkS4class{fgpm} object passed for update; and (ii) for data substitution, the argument ind.sb is
always mandatory.

\strong{Conflicting task combinations:}
\itemize{
 \item Data points deletion and substitution;
 \item Substitution and re-estimation of the same hyperparameter.
}

Note that the parameters of the model will not be updated after modifying the model unless explicitly
requested through the var.re, ls_s.re and ls_f.re arguments. If, for instance, some points are added
to the model without requesting parameter re-estimation, the new data will be included in the
training-training and training-prediction covariance matrices, but the hyperparameters will not
be updated. This allows to make updates in the data that might help to improve predictions,
without the immediate need to perform a training procedure that could be time consuming. At any later
time, the user is allowed to request the re-estimation of the hyperparameters, which will make
the model fully up to date.
}
\examples{
# deletion and addition of data points_____________________________________________________
# building the model
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0,1,length = sqrt(n.tr)), x2 = seq(0,1,length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# deleting two points
ind.dl <- sample(1:m1@n.tot, 2)
m1up <- update(m1, ind.dl = ind.dl)

# adding five points
n.nw <- 5
sIn.nw <- matrix(runif(n.nw * m1@ds), nrow = n.nw)
fIn.nw <- list(f1 = matrix(runif(n.nw*10), ncol = 10), f2 = matrix(runif(n.nw*22), ncol = 22))
sOut.nw <- fgp_BB3(sIn.nw, fIn.nw, n.nw)
m1up <- update(m1, sIn.nw = sIn.nw, fIn.nw = fIn.nw, sOut.nw = sOut.nw)


# substitution of data points______________________________________________________________
# building the model
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0,1,length = sqrt(n.tr)), x2 = seq(0,1,length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# generating substituting input data for updating
n.sb <- 2
sIn.sb <- matrix(runif(n.sb * m1@ds), nrow = n.sb)
fIn.sb <- list(f1 = matrix(runif(n.sb*10), ncol = 10), f2 = matrix(runif(n.sb*22), ncol = 22))

# generating substituting output data for updating
sOut.sb <- fgp_BB3(sIn.sb, fIn.sb, n.sb)

# generating indices for substitution
ind.sb <- sample(1:(m1@n.tot), n.sb)

# updating all, the scalar inputs, functional inputs and the outputs
m1up <- update(m1, sIn.sb = sIn.sb, fIn.sb = fIn.sb, sOut.sb = sOut.sb, ind.sb = ind.sb)

# updating only some of the data structures
m1up1 <- update(m1, sIn.sb = sIn.sb, ind.sb = ind.sb) # only the scalar inputs
m1up2 <- update(m1, sOut.sb = sOut.sb, ind.sb = ind.sb) # only the outputs
m1up3 <- update(m1, sIn.sb = sIn.sb, sOut.sb = sOut.sb, ind.sb = ind.sb) # the scalar inputs
                                                                         # and the outputs


# substitution of hyperparameters__________________________________________________________
# building the model
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0,1,length = sqrt(n.tr)), x2 = seq(0,1,length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# defining hyperparameters for substitution
var.sb <- 3
ls_s.sb <- c(2.44, 1.15)
ls_f.sb <- c(5.83, 4.12)

# updating the model
m1up <- update(m1, var.sb = var.sb, ls_s.sb = ls_s.sb, ls_f.sb = ls_f.sb)


# re-estimation of hyperparameters_________________________________________________________
# building the model
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0,1,length = sqrt(n.tr)), x2 = seq(0,1,length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# re-estimating the hyperparameters
m1up <- update(m1, var.re = TRUE) # only the variance
m1up <- update(m1, ls_s.re = TRUE) # only the scalar length-scale parameters
m1up <- update(m1, ls_s.re = TRUE, ls_f.re = TRUE) # all length-scale parameters
m1up <- update(m1, var.re = TRUE, ls_s.re = TRUE, ls_f.re = TRUE) # all hyperparameters

# same as above but now extending optimization from previously stored values
m1up <- update(m1, var.re = TRUE, extend = TRUE)
m1up <- update(m1, ls_s.re = TRUE, extend = TRUE)
m1up <- update(m1, ls_s.re = TRUE, ls_f.re = TRUE, extend = TRUE)
m1up <- update(m1, var.re = TRUE, ls_s.re = TRUE, ls_f.re = TRUE, extend = TRUE)

}
\seealso{
\strong{*} \link[funGp]{fgpm} for creation of a funGp model;

\strong{*} \link[funGp]{predict,fgpm-method} for predictions based on a \code{fgpm} model;

\strong{*} \link[funGp]{simulate,fgpm-method} for simulations based on a \code{fgpm} model.
}
\author{
José Betancourt, François Bachoc, Thierry Klein and Jérémy Rohmer
}
