% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sparsify}
\alias{sparsify}
\title{Generate a sparse version of functional data objects}
\usage{
sparsify(funDataObject, minObs, maxObs)
}
\arguments{
\item{funDataObject}{A functional data object of class
\code{\linkS4class{funData}} or \code{\linkS4class{multiFunData}}.}

\item{minObs, maxObs}{The minimal/maximal number of observation points. Must be a scalar for
univariate functional data (\code{\linkS4class{funData}} class) or a
vector of the same length as \code{funDataObject} for multivariate
functional data (\code{\linkS4class{multiFunData}} class), giving the
minimal/maximal number of observations for each element. See Details.}
}
\value{
An object of the same class as \code{funDataObject}, which is a
  sparse version of the original data.
}
\description{
This function generates an artificially sparsified version of a functional
data object of class \code{\linkS4class{funData}} (univariate) or
\code{\linkS4class{multiFunData}} (multivariate). The minimal and maximal number
of observation points for all observations can be supplied by the user.
}
\details{
The technique for artificially sparsifying the data is as described in Yao et
al. (2005): For each element \eqn{x_i^{(j)}}{x_i^(j)} of an observed
(multivariate) functional data object \eqn{x_i}, a random number
\eqn{R_i^{(j)} \in \{\mathrm{minObs}, \ldots, \mathrm{maxObs}\}}{R_i^(j)
in {\code{minObs}, \ldots, \code{maxObs}}} of observation points is generated. The points
are sampled uniformly from the full grid \eqn{\{t_{j,1} , \ldots , t_{j,
S_j}\} \subset \mathcal{T}_j}{{t_{j,1} , \ldots , t_{j, S_j}} in \calT_j}, resulting in
observations \deqn{ x_{i,r}^{(j)} = x_i^{(j)}(t_{j,r}), \quad r = 1
,\ldots,R_i^{(j)},~ j = 1, \ldots, p.}{ x_{i,r}^(j) = x_i^(j)(t_{j,r}), r = 1
,\ldots,R_i^(j), j = 1, \ldots, p.}
}
\section{Warning}{

This function is currently implemented for 1D data only.
}
\examples{
oldPar <- par(no.readonly = TRUE)
par(mfrow = c(1,1))
set.seed(1)

# univariate functional data
full <- simFunData(argvals = seq(0,1, 0.01), M = 10, eFunType = "Fourier",
                   eValType = "linear", N = 3)$simData
sparse <- sparsify(full, minObs = 4, maxObs = 10)

plot(full, main = "Sparsify")
plot(sparse, type = "p", pch = 20, add = TRUE)
legend("topright", c("Full", "Sparse"), lty = c(1, NA), pch = c(NA, 20))

# Multivariate
full <- simMultiFunData(type = "split", argvals = list(seq(0,1, 0.01), seq(-.5,.5, 0.02)),
                        M = 10, eFunType = "Fourier", eValType = "linear", N = 3)$simData
sparse <- sparsify(full, minObs = c(4, 30), maxObs = c(10, 40))

par(mfrow = c(1,2))
plot(full[[1]], main = "Sparsify (multivariate)", sub = "minObs = 4, maxObs = 10")
plot(sparse[[1]], type = "p", pch = 20, add = TRUE)

plot(full[[2]], main = "Sparsify (multivariate)", sub = "minObs = 30, maxObs = 40")
plot(sparse[[2]], type = "p", pch = 20, add = TRUE)
legend("bottomright", c("Full", "Sparse"), lty = c(1, NA), pch = c(NA, 20))

par(oldPar)
}
\references{
Yao, F., H.-G. Mueller and J.-L. Wang (2005): Functional Data
  Analysis for Sparse Longitudinal Data. Journal of the American Statistical
  Association, 100 (470), 577--590.
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{multiFunData}},
  \code{\link{simFunData}}, \code{\link{simMultiFunData}},
  \code{\link{addError}}.
}

