% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulation.R
\name{simMultiFunData}
\alias{simMultiFunData}
\title{Simulate multivariate functional data}
\usage{
simMultiFunData(type, argvals, M, eFunType, ignoreDeg = NULL, eValType, N)
}
\arguments{
\item{type}{A character string, specifying the construction method for the
multivariate eigenfunctions (either \code{"split"} or \code{"weighted"}).
See Details.}

\item{argvals}{A list, containing the observation points for each element of
the multivariate functional data that is to be simulated. The length of
\code{argvals} determines the number of elements in the resulting simulated
multivariate functional data. See Details.}

\item{M}{An integer (\code{type = "split"}) or a list of integers (\code{type
= "weighted"}), giving the number of unvariate basis functions to use. See
Details.}

\item{eFunType}{A character string (\code{type = "split"})   or a list of
character strings (\code{type = "weighted"}), specifying the type of
univariate orthonormal basis functions to use. See Details.}

\item{ignoreDeg}{A vector of integers (\code{type = "split"})   or a list of
integer vectors (\code{type = "weighted"}), specifying the degrees to
ignore when generating the univariate orthonormal bases. Defaults to
\code{NULL}. See Details.}

\item{eValType}{A character string, specifying the type of
eigenvalues/variances used for the simulation of the multivariate functions
based on the truncated Karhunen-Loeve representation. See
\code{\link{eVal}} for details.}

\item{N}{An integer, specifying the number of multivariate functions to be
  generated.}
}
\value{
\item{simData}{A \code{\linkS4class{multiFunData}} object with
  \code{N} observations, representing the simulated multivariate functional
  data.} \item{trueFuns}{A \code{\linkS4class{multiFunData}} object with
  \code{M} observations, representing the multivariate eigenfunction basis
  used for simulating the data.} \item{trueVals}{A vector of numerics,
  representing the eigenvalues used for simulating the data.}
}
\description{
This function provides a unified simulation structure for multivariate
functional data \eqn{f_1, \ldots, f_N} on one- or two-dimensional domains,
based on a truncated multivariate Karhunen-Loeve representation: \deqn{f_i(t)
= \sum_{m = 1}^M \rho_{i,m} \psi_m(t).} The multivariate eigenfunctions
(basis functions) \eqn{\psi_m}  are constructed from univariate orthonormal
bases. There are two different concepts for the construction, that can be
chosen by the parameter \code{type}: A split orthonormal basis (\code{split},
only one-dimensional domains) and weighted univariate orthonormal bases
(\code{weighted}, one- and two-dimensional domains). The scores
\eqn{\rho_{i,m}} in the Karhunen-Loeve representation are simulated
independently from a normal distribution with zero mean and decreasing
variance. See Details.
}
\details{
The parameter \code{type} defines how the eigenfunction basis for the
multivariate Karhunen-Loeve representation is constructed: \itemize{ \item
\code{type = "split"}: The basis functions of an underlying 'big' orthonormal
basis are split in \code{M} parts, translated and possibly reflected. This
yields an orthonormal basis of multivariate functions with \code{M}
elements. This option is implemented only for one-dimensional domains. \item
\code{type = "weighted":} The multivariate eigenfunction basis consists of
weighted univariate orthonormal bases.  This yields an orthonormal basis of
multivariate functions with \code{M} elements. For data on two-dimensional
domains (images), the univariate basis is constructed as a tensor product of
univariate bases in each direction (x- and y-direction). }

Depending on \code{type}, the other parameters have to be specified as
follows: \subsection{Split 'big' orthonormal basis}{ The parameters \code{M}
(integer), \code{eFunType} (character string) and \code{ignoreDeg} (integer
vector or \code{NULL}) are passed to the function \code{\link{eFun}} to
generate a univariate orthonormal basis on a 'big' interval. Subsequently,
the basis functions are split and translated, such that the \eqn{j}-th part
of the split function is defined on the interval corresponding to
\code{argvals[[j]]}. The elements of the multivariate basis functions are
given by these split parts of the original basis functions multiplied by a
random sign \eqn{\sigma_j \in \{-1,1\}, j = 1, \ldots, p}{\sigma_j in {-1,1},
j = 1, \ldots, p}.}

\subsection{Weighted orthonormal bases}{ The parameters \code{argvals, M,
eFunType} and \code{ignoreDeg} are all lists of a similar structure. They are
passed element-wise to the function \code{\link{eFun}} to generate
orthonormal basis functions for each element of the multivariate functional
data to be simulated. In case of bivariate elements (images), the
corresponding basis functions are constructed as tensor products of
orthonormal basis functions in each direction (x- and y-direction).

If the \eqn{j}-th element of the simulated data should be defined on a
one-dimensional domain, then \itemize{ \item \code{argvals[[j]]} is a list,
containing one vector of observation points. \item \code{M[[j]]} is an
integer, specifiying the number of basis functions to use for this entry.
\item  \code{eFunType[[j]]} is a character string, specifying the type of
orthonormal basis functions to use for this entry (see \code{\link{eFun}} for
possible options). \item \code{ignoreDeg[[j]]} is a vector of integers,
specifying the degrees to ignore when constructing the orthonormal basis
functions. The default value is \code{NULL}. }

If the \eqn{j}-th element of the simulated data should be defined on a
two-dimensional domain, then \itemize{ \item \code{argvals[[j]]} is a list,
containing two vectors of observation points, one for each direction
(observation points in x-direction and in y-direction). \item \code{M[[j]]}
is a vector of two integers, giving the number of basis functions for each
direction (x- and y-direction). \item \code{eFunType[[j]]} is a vector of two
character strings, giving the type of orthonormal basis functions for each
direction (x- and y-direction, see \code{\link{eFun}} for possible options).
The corresponding basis functions are constructed as tensor products of
orthonormal basis functions in each direction. \item \code{ignoreDeg[[j]]} is
a list, containing two integer vectors that specify the degrees to ignore
when constructing the orthonormal basis functions in each direction. The
default value is \code{NULL}. } The total number of basis functions (i.e. the
product of \code{M[[j]]} for all \code{j}) must be equal!}
}
\examples{
oldPar <- par(no.readonly = TRUE)

# split
split <- simMultiFunData(type = "split", argvals = list(seq(0,1,0.01), seq(-0.5,0.5,0.02)),
                 M = 5, eFunType = "Poly", eValType = "linear", N = 7)

par(mfrow = c(1,2))
plot(split$trueFuns, main = "Split: True Eigenfunctions", ylim = c(-2,2))
plot(split$simData, main = "Split: Simulated Data")

# weighted (one-dimensional domains)
weighted1D <- simMultiFunData(type = "weighted",
                 argvals = list(list(seq(0,1,0.01)), list(seq(-0.5,0.5,0.02))),
                 M = c(5,5), eFunType = c("Poly", "Fourier"), eValType = "linear", N = 7)

plot(weighted1D$trueFuns, main = "Weighted (1D): True Eigenfunctions", ylim = c(-2,2))
plot(weighted1D$simData, main = "Weighted (1D): Simulated Data")

# weighted (one- and two-dimensional domains)
weighted <- simMultiFunData(type = "weighted",
               argvals = list(list(seq(0,1,0.01), seq(0,10,0.1)), list(seq(-0.5,0.5,0.01))),
               M = list(c(5,4), 20), eFunType = list(c("Poly", "Fourier"), "Wiener"),
               eValType = "linear", N = 7)

plot(weighted$trueFuns, main = "Weighted: True Eigenfunctions (m = 2)", obs = 2)
plot(weighted$trueFuns, main = "Weighted: True Eigenfunctions (m = 15)", obs = 15)
plot(weighted$simData, main = "Weighted: Simulated Data (1st observation)", obs = 1)
plot(weighted$simData, main = "Weighted: Simulated Data (2nd observation)", obs = 2)

par(oldPar)
}
\references{
C. Happ, S. Greven (2015): Multivariate Functional Principal
  Component Analysis for Data Observed on Different (Dimensional) Domains.
  Preprint on arXiv: \url{http://arxiv.org/abs/1509.02029}
}
\seealso{
\code{\linkS4class{multiFunData}}, \code{\link{eFun}},
  \code{\link{eVal}}, \code{\link{simFunData}}, \code{\link{addError}},
  \code{\link{sparsify}}.
}

