% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ft_search.R
\name{ft_search}
\alias{ft_search}
\title{Search for full text}
\usage{
ft_search(query, from = "plos", limit = 10, plosopts = list(),
  bmcopts = list(), crossrefopts = list(), entrezopts = list(),
  arxivopts = list(), biorxivopts = list(), ...)
}
\arguments{
\item{query}{Query terms}

\item{from}{Source to query}

\item{limit}{Number of records to return.}

\item{plosopts}{PLOS options. See \code{?searchplos}}

\item{bmcopts}{BMC options. See \code{?bmc_search}}

\item{crossrefopts}{Crossref options. See \code{?cr_works}}

\item{entrezopts}{Entrez options. See \code{?entrez_search}}

\item{arxivopts}{arxiv options. See \code{?arxiv_search}}

\item{biorxivopts}{biorxiv options. See \code{?bx_search}}

\item{...}{Further args passed on to \code{\link[httr]{GET}}. Not working right now...}
}
\value{
An object of class ft, and objects of class ft_ind within each source
}
\description{
\code{ft_search} is a one stop shop for searching for articles across
many publishers and repositories. We currently support search for PLOS via the
\code{rplos} package, Crossref via the \code{rcrossref} package, Entrez via the
\code{rentrez} package, arXiv via the \code{aRxiv} package, and BMC and Biorxiv
via internal helper functions in this package. Many publishers content is searchable
via Crossref and Entrez - of course this doesn't mean that we can get full text
for those articles. In the output objects of this function, we attempt to help by
indicating what license is used for articles.
}
\examples{
\dontrun{
# Plos
(res1 <- ft_search(query='ecology', from='plos'))
res1$plos
ft_search(query='climate change', from='plos', limit=500, plosopts=list(
   fl=c('id','author','eissn','journal','counter_total_all','alm_twitterCount')))

# Crossref
(res2 <- ft_search(query='ecology', from='crossref'))
res2$crossref

# BioRxiv
(res <- ft_search(query='ecology', from='biorxiv'))
res$biorxiv

# Entrez
(res <- ft_search(query='ecology', from='entrez'))
res$entrez

# arXiv
(res <- ft_search(query='ecology', from='arxiv'))
res$arxiv

# BMC - can be very slow
(res <- ft_search(query='ecology', from='bmc'))
res$bmc

# PLOS, Crossref, and arxiv
(res <- ft_search(query='ecology', from=c('plos','crossref','arxiv')))
res$plos
res$arxiv
res$crossref
}
}

