% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa.read.R
\name{fa.read}
\alias{fa.read}
\title{Fasta File Reader (fa.read)}
\usage{
fa.read(file, legacy.mode = TRUE, seqonly = FALSE, alphabet = "aa")
}
\arguments{
\item{file}{The address of the FASTA file.}

\item{legacy.mode}{comments all lines which start with ";".}

\item{seqonly}{if it is set to true, the function will return sequences with no description.}

\item{alphabet}{is a vector which contains amino acid, RNA, or DNA alphabets.}
}
\value{
a string vector such that each element is a sequence.
}
\description{
This function reads a FASTA file. Each sequence starts with '>' in the file.
This is a general function which can be applied to all types of sequences (i.e., protein/peptide, dna, and rna).
}
\examples{

fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
sequenceVectLNC<-fa.read(file=fileLNC,alphabet="dna")

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
sequenceVectPRO<-fa.read(file=filePrs,alphabet="aa")
}
\references{
https://cran.r-project.org/web/packages/rDNAse/index.html
}
