% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPSSMdir.R
\name{readPSSMdir}
\alias{readPSSMdir}
\title{Read PSSM Directory (readPSSMdir)}
\usage{
readPSSMdir(dirPath)
}
\arguments{
\item{dirPath}{the path of a directory which contains all the VSL2 output files.}
}
\value{
a list of vectors with all the predicted disorder/order type for each amino acid. The length of the
list is equal to the number of files(sequences) and the length of each vector is the length of the sequence(i).
}
\description{
This function reads a directory that contains the output psi-blast.
It gets the directory path as the input and returns a list of vectors. Each vector includes the type for the amino acids of the sequence.
}
\examples{

pssmDir<-system.file("testForder",package="ftrCOOL")
pssmDir<-paste0(pssmDir,"/PSSMdir/")
listPredVect<-readPSSMdir(pssmDir)

}
