% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAAKpartComposition.R
\name{GAAKpartComposition}
\alias{GAAKpartComposition}
\title{Grouped Amino Acid K Part Composition}
\usage{
GAAKpartComposition(
  seqs,
  k = 5,
  normalized = TRUE,
  Grp = "locFus",
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{k}{is an integer. Each sequence should be divided to k partition(s).}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{Grp}{is a list of vectors containig amino acids. Each vector represents a category. Users can define a customized amino acid grouping, provided that the sum of all amino acids is 20 and there is no repeated amino acid in the groups.
Also, users can choose 'cTriad'(conjointTriad), 'locFus', or 'aromatic'. Each option provides specific information about the type of an amino acid grouping.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
a feature matrix with k*(number of categorizes) number of columns. The number of rows is equal to the number of
sequences.
}
\description{
In this function, amino acids are first grouped into user-defined categories.
Later, the composition of the grouped amino acid k part is computed.
Please note that this function differs from \link{AAKpartComposition} which works on individual amino acids.
}
\note{
Warning: The length of all sequences should be greater than k.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat1<-GAAKpartComposition(seqs=filePrs,k=5,Grp="aromatic")

mat2<-GAAKpartComposition(seqs=filePrs,k=3,normalized=FALSE,Grp=
list(Grp1=c("G","A","V","L","M","I","F","Y","W"),Grp2=c("K","R","H","D","E")
,Grp3=c("S","T","C","P","N","Q")))
}
